/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics.swt;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.vncviewer.config.IPropertiesFileHandler;

public class SWTVNCEventTranslator {
    private boolean shiftPressed = false;
    private boolean buttonPressed = false;
    private Hashtable<Integer, Integer> swtToKeysymCodes;
    private Properties configProperties;
    private IPropertiesFileHandler propertiesFileHandler;

    public SWTVNCEventTranslator(Properties configProperties, IPropertiesFileHandler propertiesFileHandler) {
        this.configProperties = configProperties;
        this.propertiesFileHandler = propertiesFileHandler;
        this.initKeysyms();
    }

    public void initKeysyms() {
        String swtkeysymsFile = this.configProperties.getProperty("KEYSYM_SWT_PROPERTIES_FILE");
        String keysymsFile = this.configProperties.getProperty("KEYSYM_PROPERTIES_FILE");
        String swtkeysFile = this.configProperties.getProperty("SWTKEYS_PROPERTIES_FILE");
        Properties keysymSwt = this.propertiesFileHandler.loadPropertiesFile(swtkeysymsFile);
        Properties keysyms = this.propertiesFileHandler.loadPropertiesFile(keysymsFile);
        Properties swtkeys = this.propertiesFileHandler.loadPropertiesFile(swtkeysFile);
        this.swtToKeysymCodes = new Hashtable();
        Enumeration<Object> swtcodes = keysymSwt.keys();
        while (swtcodes.hasMoreElements()) {
            String key = (String)swtcodes.nextElement();
            Integer swtCode = new Integer(swtkeys.getProperty(key));
            Integer keysymCode = Integer.decode(keysyms.getProperty(keysymSwt.getProperty(key)));
            this.swtToKeysymCodes.put(swtCode, keysymCode);
        }
    }

    public ProtocolMessage getMouseEventMessage(Event swtEvent) {
        ProtocolMessage message = new ProtocolMessage(5L);
        message.setFieldValue("buttonMask", (Object)(this.buttonPressed ? 1 : 0));
        message.setFieldValue("x-position", (Object)swtEvent.x);
        message.setFieldValue("y-position", (Object)swtEvent.y);
        return message;
    }

    public ProtocolMessage getKeyEventMessage(Event swtEvent) {
        if (swtEvent.keyCode == 131072) {
            this.shiftPressed = swtEvent.type == 1;
        }
        int keysym = this.getKeysym(swtEvent.keyCode);
        boolean pressed = swtEvent.type == 1;
        ProtocolMessage message = new ProtocolMessage(4L);
        message.setFieldValue("downFlag", (Object)(pressed ? 1 : 0));
        if (!this.shiftPressed) {
            message.setFieldValue("key", (Object)keysym);
        } else {
            message.setFieldValue("key", (Object)swtEvent.character);
        }
        return message;
    }

    public int getKeysym(int swtKeyCode) {
        Integer keysymObj = this.swtToKeysymCodes.get(new Integer(swtKeyCode));
        int keysym = keysymObj != null ? keysymObj : swtKeyCode;
        return keysym;
    }
}

