/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics.swt.img;

import java.io.DataInputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.tml.vncviewer.graphics.IPainterContext;
import org.eclipse.tml.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.tml.vncviewer.graphics.swt.img.SWTRemoteDisplayImg;
import org.eclipse.tml.vncviewer.network.AbstractVNCPainter;
import org.eclipse.tml.vncviewer.network.PixelFormat;
import org.eclipse.tml.vncviewer.network.RectHeader;

public class Painter
extends AbstractVNCPainter
implements ISWTPainter {
    protected Image image;
    protected ImageData imgData;
    protected GC imageGC;
    protected PaletteData paletteData;
    protected SWTRemoteDisplayImg parent;

    public Painter(SWTRemoteDisplayImg parent) {
        this.parent = parent;
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        super.setPixelFormat(pixelFormat);
        this.paletteData = new PaletteData(pixelFormat.getRedMax() << pixelFormat.getRedShift(), pixelFormat.getGreenMax() << pixelFormat.getGreenShift(), pixelFormat.getBlueMax() << pixelFormat.getBlueShift());
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.dispose();
        this.image = new Image((Device)this.parent.getDisplay(), width, height);
        this.imageGC = new GC((Drawable)this.image);
        this.imgData = new ImageData(width, height, this.pixelFormat.getDepth(), this.paletteData);
    }

    protected void fillRect(int pixel, int x, int y, int width, int height) {
        Color color = new Color(this.image.getDevice(), this.paletteData.getRGB(pixel));
        this.imageGC.setBackground(color);
        int[] pixels = new int[width];
        int i = 0;
        while (i < width) {
            pixels[i] = pixel;
            ++i;
        }
        int j = 0;
        while (j < height) {
            this.imgData.setPixels(x, y + j, width, pixels, 0);
            ++j;
        }
        color.dispose();
    }

    protected void setPixels(int x, int y, int width, int[] pixels, int startIndex) {
    }

    protected void setPixels(int x, int y, int width, int height, int[] pixels, int start) {
        int i = 0;
        while (i < height) {
            this.imgData.setPixels(x, y + i, width, pixels, width * i);
            ++i;
        }
    }

    public void updateRectangle(int x1, int y1, int x2, int y2) {
        double zoom = this.parent.getZoomFactor();
        int a = (int)((double)x1 * zoom);
        int b = (int)((double)y1 * zoom);
        int r = (int)((double)(x2 - x1) * zoom);
        int s = (int)((double)(y2 - y1) * zoom);
        this.parent.redrawScreen(--a, --b, ++r, ++s);
    }

    protected IPainterContext getPainterContext() {
        return new IPainterContext(){

            public void fillRect(int pixel, int x, int y, int width, int height) {
                Painter.this.fillRect(pixel, x, y, width, height);
            }

            public PixelFormat getPixelFormat() {
                return Painter.this.getPixelFormat();
            }

            public int getBytesPerPixel() {
                return Painter.this.bytesPerPixel;
            }

            public void processRectangle(RectHeader rh, DataInputStream in) throws Exception {
                Painter.this.processRectangle(rh, in);
            }

            public int readPixel(DataInputStream is) throws Exception {
                return Painter.this.readPixel(is);
            }

            public int readPixel(DataInputStream is, int bytesPerPixel) throws Exception {
                return Painter.this.readPixel(is, bytesPerPixel);
            }

            public void setPixels(int x, int y, int width, int height, int[] pixels, int start) {
                Painter.this.setPixels(x, y, width, height, pixels, start);
            }

            public int[] readpixels(DataInputStream is, int w, int h) {
                return Painter.this.readPixels(is, w, h);
            }
        };
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.imageGC != null) {
            this.imageGC.dispose();
            this.imageGC = null;
        }
    }

    public ImageData getImageData() {
        return this.imgData;
    }
}

