/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.tml.protocol.lib.IProtocolInit;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolInitException;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.exceptions.ProtoClientException;
import org.eclipse.tml.vncviewer.network.AbstractVNCPainter;
import org.eclipse.tml.vncviewer.network.DesEncoder;
import org.eclipse.tml.vncviewer.network.IRFBConstants;
import org.eclipse.tml.vncviewer.network.PixelFormat;
import org.eclipse.tml.vncviewer.network.VNCProtocolData;
import org.eclipse.tml.vncviewer.registry.VNCProtocolRegistry;

public abstract class VNCProtocol
implements IProtocolInit,
IRFBConstants {
    private static final int PROTOCOL_VERSION_MESSAGE_SIZE = 12;
    private static final int VNC_AUTHENTICATION_CHALLENGE_MESSAGE_SIZE = 16;

    protected abstract String getVersion();

    protected abstract void handShake(DataInputStream var1, OutputStream var2) throws Exception;

    protected int[] getSupportedEncodings() {
        return AbstractVNCPainter.getSupportedEncodingsStatic();
    }

    private void initPhase(ProtocolHandle handle, DataInputStream in, OutputStream out, String password) throws Exception {
        VNCProtocolData previousData = VNCProtocolRegistry.getInstance().get(handle);
        VNCProtocolData data = new VNCProtocolData();
        if (previousData != null) {
            data.setVncPainter(previousData.getVncPainter());
        }
        data.setPassword(password);
        out.write(1);
        data.setFbWidth(in.readUnsignedShort());
        data.setFbHeight(in.readUnsignedShort());
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.getPixelFormat(in);
        data.setPixelFormat(pixelFormat);
        int nameLen = in.readInt();
        byte[] serverName = new byte[nameLen];
        in.read(serverName, 0, nameLen);
        String serverNameStr = "";
        int i = 0;
        while (i < serverName.length) {
            char c = (char)serverName[i];
            serverNameStr = String.valueOf(serverNameStr) + c;
            ++i;
        }
        data.setServerName(serverNameStr);
        data.setInputStream(in);
        data.setOutputStream(out);
        VNCProtocolRegistry.getInstance().register(handle, data);
        this.sendEncodingsPreferences(this.getSupportedEncodings(), out);
    }

    void sendEncodingsPreferences(int[] encs, OutputStream out) throws IOException {
        int length = encs.length;
        byte[] b = new byte[4 + 4 * encs.length];
        b[0] = 2;
        b[1] = 0;
        b[2] = (byte)(length >> 8 & 0xFF);
        b[3] = (byte)(length & 0xFF);
        int i = 0;
        while (i < length) {
            b[4 + 4 * i] = (byte)(encs[i] >> 24 & 0xFF);
            b[5 + 4 * i] = (byte)(encs[i] >> 16 & 0xFF);
            b[6 + 4 * i] = (byte)(encs[i] >> 8 & 0xFF);
            b[7 + 4 * i] = (byte)(encs[i] & 0xFF);
            ++i;
        }
        out.write(b);
    }

    protected void compareVersion(byte[] b) throws Exception {
        String clientVersion = this.getVersion();
        String serverVersion = new String(b);
        boolean versionOk = false;
        if (serverVersion.equals(clientVersion)) {
            versionOk = true;
        } else if (serverVersion.length() == clientVersion.length() && serverVersion.substring(0, 10).equals(clientVersion.substring(0, 10)) && serverVersion.charAt(10) > clientVersion.charAt(10)) {
            versionOk = true;
        }
        if (!versionOk) {
            throw new ProtoClientException("Wrong protocol version.");
        }
    }

    protected void negotiateProtocol(DataInputStream in, OutputStream out) throws Exception {
        byte[] b = new byte[12];
        in.readFully(b, 0, 12);
        this.compareVersion(b);
        out.write(this.getVersion().getBytes());
    }

    protected int negotiateSecurity(DataInputStream in, OutputStream out) throws Exception {
        int[] securityTypes = this.readSecurityTypes(in);
        int securityType = this.chooseSecurityType(securityTypes);
        if (securityType != 0) {
            this.sendSecurityType(out, securityType);
        }
        return securityType;
    }

    protected int chooseSecurityType(int[] securityTypes) throws Exception {
        int i = 0;
        while (i < securityTypes.length) {
            if (this.securityTypeSupported(securityTypes[i])) {
                return securityTypes[i];
            }
            ++i;
        }
        return 0;
    }

    protected int[] readSecurityTypes(DataInputStream in) throws Exception {
        int[] result = null;
        int secTypesNumber = in.readByte();
        if (secTypesNumber > 0) {
            result = new int[secTypesNumber];
            int i = 0;
            while (i < secTypesNumber) {
                result[i] = in.readByte();
                ++i;
            }
        } else {
            this.handshakeFail(in);
        }
        return result;
    }

    protected void sendSecurityType(OutputStream out, int securityType) throws Exception {
        out.write((byte)securityType);
    }

    protected void handshakeFail(DataInputStream in) throws Exception {
        StringBuffer reason = new StringBuffer();
        int failReasonLength = in.readInt();
        int j = 0;
        while (j < failReasonLength) {
            reason.append((char)in.readByte());
            ++j;
        }
        throw new Exception("Handshake failed: " + reason.toString());
    }

    protected boolean securityTypeSupported(int type) {
        switch (type) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected void authenticate(DataInputStream in, OutputStream out, String password, int securityType) throws Exception {
        switch (securityType) {
            case 1: {
                break;
            }
            case 2: {
                this.authenticateVNC(in, out, password);
                break;
            }
            default: {
                throw new Exception("Handshake failed: unsupported security type " + securityType);
            }
        }
    }

    protected void authenticateVNC(DataInputStream in, OutputStream out, String password) throws Exception {
        byte[] challenge = new byte[16];
        in.readFully(challenge, 0, 16);
        byte[] pwd = new byte[8];
        byte[] pwdOrg = password != null ? password.getBytes() : new byte[]{};
        int i = 0;
        while (i < 8 && i < pwdOrg.length) {
            pwd[i] = pwdOrg[i];
            ++i;
        }
        DesEncoder des = new DesEncoder(pwd);
        des.encode(challenge, challenge);
        out.write(challenge);
    }

    protected void readAuthenticationResult(DataInputStream in) throws Exception {
        int securityResult = in.readInt();
        if (securityResult != 0) {
            this.handshakeFail(in);
        }
    }

    public void clientInit(ProtocolHandle handle, DataInputStream in, OutputStream out, Map parameters) throws ProtocolInitException {
        int securityType;
        String password = (String)parameters.get("password");
        try {
            this.negotiateProtocol(in, out);
        }
        catch (Exception e) {
            VNCViewerPlugin.log(VNCProtocol.class).error("VNC protocol negotiation error: " + e.getMessage());
            throw new ProtocolInitException("VNC protocol negotiation error.");
        }
        try {
            securityType = this.negotiateSecurity(in, out);
        }
        catch (Exception e) {
            VNCViewerPlugin.log(VNCProtocol.class).error("VNC security negotiation error: " + e.getMessage());
            throw new ProtocolInitException("VNC security negotiation error.");
        }
        try {
            this.authenticate(in, out, password, securityType);
            this.readAuthenticationResult(in);
        }
        catch (Exception e) {
            VNCViewerPlugin.log(VNCProtocol.class).error("VNC authenticate error: " + e.getMessage());
            throw new ProtocolInitException("VNC authenticate error.");
        }
        try {
            this.initPhase(handle, in, out, password);
        }
        catch (Exception e) {
            VNCViewerPlugin.log(VNCProtocol.class).error("VNC Init Phase error: " + e.getMessage());
            throw new ProtocolInitException("VNC Init Phase error.");
        }
    }

    public void serverInit(ProtocolHandle handle, DataInputStream in, OutputStream out, Map parameters) throws ProtocolInitException {
    }
}

