/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.internal.model;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.device.model.handler.IDeviceHandler;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileDeviceType
implements IDeviceType {
    private static final String ELEMENT_DEVICE = "deviceType";
    private static final String ATR_ICON = "icon";
    private static final String ATR_IS_PERSISTENT = "isPersistent";
    private static final String PROPERTY_ICON = "icon";
    private String id;
    private String label;
    private String bundleName;
    private boolean isAbstract = false;
    private String superClass;
    private IDeviceHandler handler;
    private ImageDescriptor image;
    private Properties properties = new Properties();
    private List<IService> services;
    private boolean isPersistent = true;

    public MobileDeviceType(String id, String label) {
        this.id = id;
        this.label = label;
        IExtension fromPlugin = PluginUtils.getExtension((String)"org.eclipse.tml.deviceTypes", (String)id);
        String isPersistentStr = PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATR_IS_PERSISTENT);
        if (isPersistentStr != null) {
            this.isPersistent = Boolean.valueOf(isPersistentStr);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public String getBundleName() {
        return this.bundleName;
    }

    @Override
    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    @Override
    public List<IService> getServices() {
        return this.services;
    }

    @Override
    public void setServices(List<IService> services) {
        this.services = services;
        for (IService service : services) {
            service.setParent(this);
        }
    }

    @Override
    public IDeviceHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(IDeviceHandler handler) {
        this.handler = handler;
    }

    @Override
    public Image getImage() {
        if (this.getProperties().containsKey("icon")) {
            String path = this.getProperties().getProperty("icon");
            Image image = DevicePlugin.getDefault().getImageFromRegistry(this.getBundleName(), path);
            return image;
        }
        IExtension fromPlugin = PluginUtils.getExtension((String)"org.eclipse.tml.deviceTypes", (String)this.id);
        String iconName = PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)"icon");
        ImageDescriptor descr = null;
        try {
            descr = DevicePlugin.getPluginImage((Bundle)fromPlugin.getDeclaringPluginDescriptor().getPlugin().getBundle(), (String)iconName);
        }
        catch (InvalidRegistryObjectException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return descr.createImage();
    }

    public String toString() {
        return "[DeviceType: id=" + (this.id == null ? "" : this.id) + ",label=" + (this.label == null ? "" : this.label) + ",bundleName=" + (this.bundleName == null ? "" : this.bundleName) + "]";
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    @Override
    public String getSuperClass() {
        return this.superClass;
    }

    @Override
    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    @Override
    public boolean isPersistent() {
        return this.isPersistent;
    }
}

