/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib;

import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.internal.model.ClientModel;
import org.eclipse.tml.protocol.lib.internal.model.ServerModel;

public class ProtocolActionDelegate {
    public static void requestStopProtocol(ProtocolHandle handle) {
        BasePlugin.logDebugMessage((String)"ProtocolActionDelegate", (String)("A user is requesting to stop the protocol identified by " + handle));
        ClientModel clientModel = ClientModel.getInstance();
        clientModel.requestStopProtocol(handle);
        ServerModel serverModel = ServerModel.getInstance();
        serverModel.stopListeningToPort(handle);
    }

    public static void requestRestartProtocol(ProtocolHandle handle) {
        BasePlugin.logDebugMessage((String)"ProtocolActionDelegate", (String)("An user is requesting to restart the protocol identified by " + handle));
        ClientModel clientModel = ClientModel.getInstance();
        clientModel.requestRestartProtocol(handle);
        ServerModel serverModel = ServerModel.getInstance();
        serverModel.requestRestartProtocol(handle);
    }

    public static void sendMessageToServer(ProtocolHandle handle, ProtocolMessage message) {
        ClientModel model = ClientModel.getInstance();
        model.sendMessage(handle, message);
    }

    public static boolean isProtocolRunning(ProtocolHandle handle) {
        return ClientModel.getInstance().isClientProtocolRunning(handle) || ServerModel.getInstance().isListeningToPort(handle);
    }
}

