/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.vncviews.views;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.vncviewer.vncviews.views.VNCViewerView;

public class OpenConnectionDialog
extends Dialog {
    private static final String DIALOG_TITLE = "New VNC connection";
    private static final String DEFAULT_PORT = "5900";
    private Text hostText;
    private Text portText;
    private Combo protocolVersion;
    private Text passwordText;
    private Button bypassProxyButton;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            OpenConnectionDialog.this.validate();
        }
    };

    public OpenConnectionDialog(Shell parent) {
        super(parent);
    }

    protected Point getInitialSize() {
        return new Point(240, 290);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite external = this.createDefaultComposite(parent, 1, 17);
        Composite fields = this.createDefaultComposite(external, 2, 0);
        int cols = 20;
        Label hostLabel = new Label(fields, 131072);
        this.hostText = new Text(fields, parent.getStyle() | 0x800);
        Label portLabel = new Label(fields, 131072);
        this.portText = new Text(fields, parent.getStyle() | 0x800);
        Label passwordLabel = new Label(fields, 131072);
        this.passwordText = new Text(fields, parent.getStyle() | 0x800 | 0x400000);
        GC gc = new GC((Drawable)this.hostText.getDisplay());
        int width = gc.getFontMetrics().getAverageCharWidth() * cols;
        int height = gc.getFontMetrics().getHeight();
        GridData gridData = new GridData();
        gridData.heightHint = height;
        gridData.widthHint = width;
        hostLabel.setText("Host:");
        this.hostText.setLayoutData((Object)gridData);
        this.hostText.setSize(this.hostText.computeSize(width, height));
        portLabel.setText("Port:");
        this.portText.setSize(this.portText.computeSize(width, height));
        this.portText.setLayoutData((Object)gridData);
        this.portText.setText(DEFAULT_PORT);
        passwordLabel.setText("Password:");
        this.passwordText.setSize(this.passwordText.computeSize(width, height));
        this.passwordText.setLayoutData((Object)gridData);
        this.createCombo(external);
        Composite bypassComposite = new Composite(external, 0);
        GridData gdata = new GridData(4, 4, true, false);
        bypassComposite.setLayoutData((Object)gdata);
        GridLayout glayout = new GridLayout();
        bypassComposite.setLayout((Layout)glayout);
        this.bypassProxyButton = new Button(bypassComposite, 32);
        Point p = this.bypassProxyButton.getLocation();
        this.bypassProxyButton.setLocation(p.x, p.y + 100);
        this.bypassProxyButton.setText("Bypass proxy settings");
        this.hostText.addModifyListener(this.listener);
        this.portText.addModifyListener(this.listener);
        return external;
    }

    protected void okPressed() {
        String host = this.hostText.getText();
        int port = Integer.valueOf(this.portText.getText());
        String version = this.protocolVersion.getItem(this.protocolVersion.getSelectionIndex());
        String password = this.passwordText.getText();
        ConnectJob job = new ConnectJob(host, port, password, version, this.bypassProxyButton.getSelection());
        job.schedule();
        super.okPressed();
    }

    public boolean isStopExistingClient() {
        Display display = Display.getDefault();
        RunnableMessageDialog msgd = new RunnableMessageDialog(display);
        display.syncExec((Runnable)msgd);
        return msgd.returnCode == 0;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        throw new Error("Unresolved compilation problem: \n\tOverride cannot be resolved to a type\n");
    }

    @Override
    protected void cancelPressed() {
        throw new Error("Unresolved compilation problem: \n\tOverride cannot be resolved to a type\n");
    }

    private Composite createDefaultComposite(Composite parent, int columns, int left) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        if (columns > 0) {
            layout.numColumns = columns;
        }
        layout.marginLeft = left + 5;
        layout.marginTop = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void createCombo(Composite composite) {
        Composite comboComposite = new Composite(composite, 0);
        GridData data = new GridData(4, 4, true, false);
        comboComposite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        comboComposite.setLayout((Layout)gridLayout);
        Label configListLabel = new Label(comboComposite, 0);
        configListLabel.setText("VNC Protocol used as base:");
        Combo protocolCombo = new Combo(comboComposite, 8);
        data = new GridData(4, 0x1000000, true, false);
        protocolCombo.setLayoutData((Object)data);
        protocolCombo.add("VNC 3.3");
        protocolCombo.add("VNC 3.7");
        protocolCombo.add("VNC 3.8");
        protocolCombo.select(2);
        this.protocolVersion = protocolCombo;
    }

    private void validate() {
        if (this.hostText != null && this.portText != null) {
            this.getButton(0).setEnabled(this.hostText.getText().length() > 0 && this.portText.getText().length() > 0);
        }
    }

    public class ConnectJob
    extends Job {
        final String host;
        final int port;
        final String password;
        final String version;
        final boolean isBypassProxy;

        public ConnectJob(String host, int port, String password, String version, boolean isBypassProxy) {
            super("Open VNC connection with " + host + ":" + port);
            this.host = host;
            this.port = port;
            this.password = password;
            this.version = version;
            this.isBypassProxy = isBypassProxy;
        }

        public IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Checking Viewer state...", 2);
            if (VNCViewerView.getSWTRemoteDisplay().isActive()) {
                if (OpenConnectionDialog.this.isStopExistingClient()) {
                    VNCViewerView.stop();
                    try {
                        VNCViewerView.stopProtocol();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    monitor.done();
                    return Status.OK_STATUS;
                }
            }
            if (!this.isStepNeeded(monitor, "Starting VNC client...")) {
                return Status.CANCEL_STATUS;
            }
            VNCViewerView.start(this.host, this.port, this.version, this.password, this.isBypassProxy);
            monitor.done();
            return Status.OK_STATUS;
        }

        private boolean isStepNeeded(IProgressMonitor monitor, String stepName) {
            if (!monitor.isCanceled()) {
                monitor.worked(1);
                monitor.setTaskName(stepName);
                return true;
            }
            return false;
        }
    }

    private class RunnableMessageDialog
    implements Runnable {
        private Display display;
        int returnCode;

        public RunnableMessageDialog(Display display) {
            this.display = display;
        }

        public void run() {
            MessageDialog dialog = new MessageDialog(this.display.getActiveShell(), "Stop VNC session", null, "Stop existing VNC session for " + VNCViewerView.getCurrentHost() + ":" + VNCViewerView.getCurrentPort() + "?", 3, new String[]{"Stop", "Cancel"}, 0);
            dialog.open();
            this.returnCode = dialog.getReturnCode();
        }
    }
}

