/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.tml.framework.device.DeviceUtils;
import org.eclipse.tml.framework.device.model.AbstractMobileInstance;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.device.model.handler.ServiceHandlerAction;
import org.eclipse.tml.framework.device.ui.DeviceUIPlugin;
import org.eclipse.ui.PlatformUI;

public class InstanceServicesComposite
extends Composite {
    private static boolean showAllServices = true;
    private static int buttonsOrienation = 256;
    private IInstance instance = null;
    private static final String SERVICES_LABEL = "Operations";
    private static final String SERVICES_FILTERED_LABEL = "Operations (filtered)";
    private static final String NO_LABEL = "";
    private static final int DEFAULT_BUTTONS_WIDTH = 120;
    private static final int DEFAULT_BUTTONS_HEIGHT = 30;
    private static final int MAX_BUTTON_STRING_SIZE = 12;
    private static final int DEFAULT_BUTTON_IMAGE_SIZE = 16;
    public static final String AVAILABILITY_TOOL_TIP_TEXT = "Filter operations by availability";
    private CLabel label;
    private ToolBar toolBar;
    private ViewForm viewForm;
    private Listener createServicesAreaListener = new Listener(){

        public void handleEvent(Event event) {
            InstanceServicesComposite.this.createServicesArea();
        }
    };

    public InstanceServicesComposite(Composite parent) {
        super(parent, 0);
        this.createContents();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InstanceServicesComposite.this.label.dispose();
                InstanceServicesComposite.this.label = null;
                InstanceServicesComposite.this.toolBar.dispose();
                InstanceServicesComposite.this.toolBar = null;
            }
        });
    }

    public void setSelectedInstance(IInstance instance) {
        this.instance = instance;
        this.createServicesArea();
    }

    private void createContents() {
        this.setLayout((Layout)new FillLayout());
        this.viewForm = new ViewForm((Composite)this, 0);
        this.viewForm.setLayout((Layout)new GridLayout());
        this.createToolbarArea();
        this.createServicesArea();
    }

    private void createToolbarArea() {
        this.label = new CLabel((Composite)this.viewForm, 0);
        this.label.setText("Services");
        this.viewForm.setTopLeft((Control)this.label);
        this.toolBar = new ToolBar((Composite)this.viewForm, 0x800040);
        this.viewForm.setTopCenter((Control)this.toolBar);
        ToolBarManager toolBarMgr = new ToolBarManager(this.toolBar);
        toolBarMgr.add((IAction)new ServicesFilterAction());
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.add((IAction)new ServicesOrientationAction());
        toolBarMgr.update(true);
    }

    private void createServicesArea() {
        Control oldContent = this.viewForm.getContent();
        this.viewForm.setContent(null);
        if (oldContent != null) {
            oldContent.dispose();
            oldContent = null;
        }
        ScrolledComposite scrollComposite = new ScrolledComposite((Composite)this.viewForm, 768);
        Composite servicesComposite = new Composite((Composite)scrollComposite, 0);
        servicesComposite.setBackground(this.getDisplay().getSystemColor(1));
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        rowLayout.pack = false;
        rowLayout.justify = false;
        rowLayout.type = buttonsOrienation;
        rowLayout.marginLeft = 5;
        rowLayout.marginTop = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginBottom = 5;
        rowLayout.spacing = 5;
        servicesComposite.setLayout((Layout)rowLayout);
        if (this.instance != null) {
            IDeviceType device = DeviceUtils.getDeviceType((IInstance)this.instance);
            ArrayList<Button> buttons = new ArrayList<Button>();
            List services = device.getServices();
            for (IService service : services) {
                if (!service.isVisible()) continue;
                boolean inTransition = ((AbstractMobileInstance)this.instance).getStateMachineHandler().isTransitioning();
                boolean isServiceEnabled = service.getStatusTransitions(this.instance.getStatus()) != null;
                boolean bl = isServiceEnabled = isServiceEnabled && !inTransition;
                if (!showAllServices && !isServiceEnabled) continue;
                Button serviceButton = new Button(servicesComposite, 8);
                buttons.add(serviceButton);
                serviceButton.setEnabled(isServiceEnabled);
                serviceButton.addListener(13, (Listener)new ServiceHandlerAction(this.instance, service.getHandler()));
                serviceButton.addListener(13, this.createServicesAreaListener);
                serviceButton.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        Listener[] selectionListeners;
                        Listener[] listenerArray = selectionListeners = e.widget.getListeners(13);
                        int n = selectionListeners.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Listener selectionListener = listenerArray[n2];
                            e.widget.removeListener(13, selectionListener);
                            ++n2;
                        }
                    }
                });
                RowData data = new RowData();
                data.width = 120;
                data.height = 30;
                serviceButton.setLayoutData((Object)data);
                String serviceName = service.getName();
                serviceButton.setToolTipText(serviceName);
                if (serviceName.length() > 12) {
                    serviceName = serviceName.substring(0, 12).concat("...");
                }
                serviceButton.setText(serviceName);
                ImageData serviceImageData = service.getImage().getImageData().scaledTo(16, 16);
                Image serviceImage = new Image((Device)serviceButton.getDisplay(), serviceImageData);
                serviceButton.setImage(serviceImage);
            }
        }
        scrollComposite.setContent((Control)servicesComposite);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setExpandHorizontal(true);
        Point compositeSize = servicesComposite.computeSize(-1, -1);
        scrollComposite.setMinSize(130, compositeSize.y);
        this.viewForm.setContent((Control)scrollComposite);
        if (this.instance == null) {
            this.label.setText(NO_LABEL);
            this.toolBar.setVisible(false);
        } else {
            if (showAllServices) {
                this.label.setText(SERVICES_LABEL);
            } else {
                this.label.setText(SERVICES_FILTERED_LABEL);
            }
            this.toolBar.setVisible(true);
        }
    }

    private class ServicesFilterAction
    extends Action {
        public ServicesFilterAction() {
            super("filter");
            PlatformUI.getPreferenceStore().setDefault("org.eclipse.tml.framework.device.uiSERVICE_BUTTONS_ORIENTATION", 256);
            PlatformUI.getPreferenceStore().setDefault("org.eclipse.tml.framework.device.uiFILTER_SERVICE_BY_AVAILABILITY", false);
            showAllServices = !PlatformUI.getPreferenceStore().getBoolean("org.eclipse.tml.framework.device.uiFILTER_SERVICE_BY_AVAILABILITY");
            this.setToolTipText(InstanceServicesComposite.AVAILABILITY_TOOL_TIP_TEXT);
            this.setChecked(!showAllServices);
            this.setImageDescriptor(DeviceUIPlugin.getDefault().getImageDescriptor("ICON_FILTER"));
        }

        public void run() {
            showAllServices = !showAllServices;
            this.setChecked(!showAllServices);
            PlatformUI.getPreferenceStore().setValue("org.eclipse.tml.framework.device.uiFILTER_SERVICE_BY_AVAILABILITY", !showAllServices);
            InstanceServicesComposite.this.createServicesArea();
        }
    }

    private class ServicesOrientationAction
    extends Action {
        public ServicesOrientationAction() {
            super("orientation");
            buttonsOrienation = PlatformUI.getPreferenceStore().getInt("org.eclipse.tml.framework.device.uiSERVICE_BUTTONS_ORIENTATION");
            this.setToolTipText("Toggle vertical/horizontal orientation");
            if (buttonsOrienation == 256) {
                this.setImageDescriptor(DeviceUIPlugin.getDefault().getImageDescriptor("ICON_HORIZONTAL"));
            } else {
                this.setImageDescriptor(DeviceUIPlugin.getDefault().getImageDescriptor("ICON_VERTICAL"));
            }
        }

        public void run() {
            if (buttonsOrienation == 256) {
                buttonsOrienation = 512;
                this.setImageDescriptor(DeviceUIPlugin.getDefault().getImageDescriptor("ICON_VERTICAL"));
            } else {
                buttonsOrienation = 256;
                this.setImageDescriptor(DeviceUIPlugin.getDefault().getImageDescriptor("ICON_HORIZONTAL"));
            }
            PlatformUI.getPreferenceStore().setValue("org.eclipse.tml.framework.device.uiSERVICE_BUTTONS_ORIENTATION", buttonsOrienation);
            InstanceServicesComposite.this.createServicesArea();
        }
    }
}

