/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device;

import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.framework.status.StatusManager;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DevicePlugin
extends BasePlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.tml.framework.device";
    public static final String DEVICE_TYPES_EXTENSION_POINT_ID = "org.eclipse.tml.deviceTypes";
    @Deprecated
    public static final String DEVICE_ID = "org.eclipse.tml.device";
    public static final String SERVICE_ID = "org.eclipse.tml.service";
    public static final String STATUS_ID = "org.eclipse.tml.status";
    public static final String SERVICE_DEF_ID = "org.eclipse.tml.serviceDefinition";
    public static final String ICON_DEVICE = "ICON_DEVICE";
    public static final String ICON_SERVICE = "ICON_SERVICE";
    public static final String ICON_MOVING = "ICON_MOVING";
    public static final String ICON_BOOK = "ICON_BOOK";
    public static final String ICON_GAMEBOARD = "ICON_GAMEBOARD";
    public static final String ICON_NEW_BOOK = "ICON_NEW_BOOK";
    public static final String ICON_REMOVE = "ICON_REMOVE";
    public static final String ICON_START = "ICON_START";
    public static final String ICON_STOP = "ICON_STOP";
    public static final String ICON_REFRESH = "ICON_REFRESH";
    public static final String ICON_INACTIVE = "ICON_INACTIVE";
    public static final String ICON_PROPERTY = "ICON_PROPERTY";
    public static final String TML_STATUS_UNAVAILABLE = "UNAVAILABLE";
    public static final String TML_STATUS_IDLE = "IDLE";
    public static final String TML_STATUS_OFF = "OFF";
    public static final String TML_STATUS_INACTIVE = "INACTIVE";
    public static final Properties DEFAULT_PROPERTIES = new Properties();
    private static DevicePlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static DevicePlugin getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry() {
        String path = DevicePlugin.getIconPath();
        this.putImageInRegistry(ICON_DEVICE, String.valueOf(path) + "full/obj16/device.gif");
        this.putImageInRegistry(ICON_SERVICE, String.valueOf(path) + "full/obj16/service.gif");
        this.putImageInRegistry(ICON_START, String.valueOf(path) + "full/obj16/start.png");
        this.putImageInRegistry(ICON_STOP, String.valueOf(path) + "full/obj16/stop.png");
        this.putImageInRegistry(ICON_REFRESH, String.valueOf(path) + "full/obj16/refresh.gif");
        this.putImageInRegistry(ICON_INACTIVE, String.valueOf(path) + "full/obj16/inactive.gif");
        this.putImageInRegistry(ICON_MOVING, String.valueOf(path) + "movingBox.gif");
        this.putImageInRegistry(ICON_BOOK, String.valueOf(path) + "book.gif");
        this.putImageInRegistry(ICON_GAMEBOARD, String.valueOf(path) + "gameboard.gif");
        this.putImageInRegistry(ICON_NEW_BOOK, String.valueOf(path) + "newbook.gif");
        this.putImageInRegistry(ICON_REMOVE, String.valueOf(path) + "remove.gif");
        this.putImageInRegistry(ICON_PROPERTY, String.valueOf(path) + "property.gif");
    }

    public void earlyStartup() {
        DEFAULT_PROPERTIES.setProperty("host", "127.0.0.1");
        DEFAULT_PROPERTIES.setProperty("display", ":0.0");
        DEFAULT_PROPERTIES.setProperty("port", "5900");
        StatusManager.getInstance().listStatus();
    }

    public Image getImageFromRegistry(String bundleName, String iconPath) {
        String key = String.valueOf(bundleName) + ":" + iconPath;
        Image image = this.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor descriptor = null;
            Bundle bundle = Platform.getBundle((String)bundleName);
            URL url = bundle.getResource(iconPath);
            if (url != null) {
                descriptor = ImageDescriptor.createFromURL((URL)url);
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            this.getImageRegistry().put(key, descriptor);
            image = this.getImageRegistry().get(key);
        }
        return image;
    }
}

