/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.framework.device.DeviceUtils;
import org.eclipse.tml.framework.device.events.IInstanceListener;
import org.eclipse.tml.framework.device.events.InstanceEvent;
import org.eclipse.tml.framework.device.events.InstanceEventManager;
import org.eclipse.tml.framework.device.factory.InstanceRegistry;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IInstanceRegistry;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.device.model.handler.ServiceHandlerAction;
import org.eclipse.tml.framework.device.ui.view.provider.InstanceContentProvider;
import org.eclipse.tml.framework.device.ui.view.provider.InstanceLabelProvider;
import org.eclipse.tml.framework.device.ui.view.sorter.InstanceSorter;
import org.eclipse.tml.framework.device.ui.view.sorter.StatusSorter;
import org.eclipse.tml.framework.status.IStatus;
import org.eclipse.tml.framework.status.StatusRegistry;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;

public class InstanceView
extends ViewPart
implements IInstanceListener,
IPartListener2 {
    private static final String MENU_DELETE = "Delete";
    private static final String MENU_PROPERTIES = "Properties";
    private static final String MENU_SORT_BY = "Sort by";
    private static final String ACTION_DEVICES = "Devices";
    private static final String ACTION_STATUS = "Status";
    private static final String PROPERTY_EDITOR_ID = "org.eclipse.tml.framework.device.ui.editors.InstancePropertyEditorDefault";
    protected TreeViewer treeViewer;
    protected Text text;
    protected InstanceLabelProvider labelProvider;
    protected boolean enablePropertiesMenu = false;
    protected Action instanceSorterAction;
    protected Action statusSorterAction;
    protected ViewerSorter instanceSorter;
    protected ViewerSorter statusSorter;
    protected IInstanceRegistry root;

    public InstanceView() {
        InstanceEventManager.getInstance().addInstanceListener((IInstanceListener)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
    }

    public void partClosed(IWorkbenchPartReference ref) {
        if (ref.getPart(false) == this) {
            InstanceEventManager.getInstance().removeInstanceListener((IInstanceListener)this);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.text = new Text(parent, 2060);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.text.setLayoutData((Object)layoutData);
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)new InstanceContentProvider());
        this.labelProvider = new InstanceLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setUseHashlookup(true);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        this.createFiltersAndSorters();
        this.createActions();
        this.createMenus();
        this.hookListeners();
        this.treeViewer.setInput((Object)this.getInitalInput());
        this.treeViewer.expandAll();
    }

    protected void createFiltersAndSorters() {
        this.instanceSorter = new InstanceSorter();
        this.statusSorter = new StatusSorter();
    }

    protected void hookListeners() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InstanceView.this.enablePropertiesMenu = false;
                if (event.getSelection().isEmpty()) {
                    InstanceView.this.text.setText("");
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    for (Object domain : selection) {
                        if (!(domain instanceof IInstance)) continue;
                        String value = InstanceView.this.labelProvider.getText(domain);
                        toShow.append(value);
                        toShow.append(", ");
                        InstanceManager.getInstance().setInstance((IInstance)domain);
                        InstanceView.this.enablePropertiesMenu = true;
                    }
                    if (toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    InstanceView.this.text.setText(InstanceManager.getInstance().getCurrentInstance().getName());
                }
            }
        });
    }

    protected void createActions() {
        this.instanceSorterAction = new Action(ACTION_DEVICES){

            public void run() {
                InstanceView.this.updateSorter(InstanceView.this.instanceSorterAction);
            }
        };
        this.instanceSorterAction.setChecked(false);
        this.statusSorterAction = new Action(ACTION_STATUS){

            public void run() {
                InstanceView.this.updateSorter(InstanceView.this.statusSorterAction);
            }
        };
        this.statusSorterAction.setChecked(false);
    }

    protected void removeSelected() {
        if (this.treeViewer.getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        List selectionList = selection.toList();
        for (IInstance instance : selectionList) {
            InstanceManager.getInstance().deleteInstance(instance);
        }
    }

    protected void createMenus() {
        IMenuManager rootMenuManager = this.getViewSite().getActionBars().getMenuManager();
        rootMenuManager.setRemoveAllWhenShown(true);
        rootMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                InstanceView.this.fillMenu(mgr);
            }
        });
        this.fillMenu(rootMenuManager);
    }

    protected void fillMenu(IMenuManager rootMenuManager) {
        MenuManager sortSubmenu = new MenuManager(MENU_SORT_BY);
        rootMenuManager.add((IContributionItem)sortSubmenu);
        sortSubmenu.add((IAction)this.instanceSorterAction);
        sortSubmenu.add((IAction)this.statusSorterAction);
        Menu menu = new Menu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                if (InstanceView.this.enablePropertiesMenu) {
                    InstanceView.this.fillMenuContext(menu, InstanceManager.getInstance().getCurrentInstance());
                }
            }
        });
    }

    protected void fillMenuContext(Menu menu, IInstance instance) {
        IDeviceType device = DeviceUtils.getDeviceType((IInstance)instance);
        MenuItem newItem = null;
        newItem = new MenuItem(menu, 8);
        newItem.setText(MENU_DELETE);
        newItem.addListener(13, (Listener)new MenuDeleteListener());
        newItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        String statusId = instance.getStatus();
        IStatus status = StatusRegistry.getInstance().getStatus(statusId);
        newItem.setEnabled(status.canDeleteInstance());
        newItem = new MenuItem(menu, 2);
        newItem = new MenuItem(menu, 8);
        newItem.setText(MENU_PROPERTIES);
        newItem.addListener(13, (Listener)new MenuPropertiesListener());
        newItem = new MenuItem(menu, 2);
        for (IService service : device.getServices()) {
            if (!service.isVisible()) continue;
            newItem = new MenuItem(menu, 8);
            newItem.setImage(service.getImage().createImage());
            newItem.setEnabled(service.getStatusTransitions(instance.getStatus()) != null);
            newItem.setText(service.getName());
            newItem.addListener(13, (Listener)new ServiceHandlerAction(instance, service.getHandler()));
        }
    }

    protected void updateSorter(Action action) {
        if (action == this.instanceSorterAction) {
            if (action.isChecked()) {
                this.treeViewer.setSorter(this.instanceSorter);
                this.statusSorterAction.setChecked(!this.instanceSorterAction.isChecked());
            } else {
                this.treeViewer.setSorter(null);
            }
        } else if (action == this.statusSorterAction) {
            if (action.isChecked()) {
                this.instanceSorterAction.setChecked(!this.statusSorterAction.isChecked());
                this.treeViewer.setSorter(this.statusSorter);
            } else {
                this.treeViewer.setSorter(null);
            }
        }
    }

    public IInstanceRegistry getInitalInput() {
        InstanceManager.getInstance();
        return InstanceRegistry.getInstance();
    }

    public void setFocus() {
    }

    public void instanceCreated(InstanceEvent e) {
    }

    public void instanceDeleted(InstanceEvent e) {
    }

    public void instanceLoaded(InstanceEvent e) {
        this.refreshViewer();
    }

    public void instanceUpdated(InstanceEvent e) {
        this.refreshViewer();
    }

    public void instanceUnloaded(InstanceEvent e) {
        this.refreshViewer();
    }

    private void refreshViewer() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                InstanceView.this.treeViewer.setInput((Object)InstanceView.this.getInitalInput());
                InstanceView.this.treeViewer.refresh();
                InstanceView.this.treeViewer.expandAll();
            }
        });
    }

    private class MenuDeleteListener
    implements Listener {
        private MenuDeleteListener() {
        }

        public void handleEvent(Event event) {
            InstanceView.this.removeSelected();
        }
    }

    private class MenuPropertiesListener
    implements Listener {
        private MenuPropertiesListener() {
        }

        public void handleEvent(Event event) {
            IInstance adaptable = InstanceManager.getInstance().getCurrentInstance();
            Shell shell = new Shell();
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)adaptable, (String)InstanceView.PROPERTY_EDITOR_ID, (String[])new String[0], null);
            dialog.open();
        }
    }
}

