/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.internal.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tml.protocol.exceptions.MalformedProtocolExtensionException;
import org.eclipse.tml.protocol.internal.model.PluginProtocolModel;
import org.eclipse.tml.protocol.internal.model.ProtocolBean;
import org.eclipse.tml.protocol.internal.reader.IExtensionConstants;
import org.eclipse.tml.protocol.lib.IMessageHandler;
import org.eclipse.tml.protocol.lib.IProtocolInit;
import org.eclipse.tml.protocol.lib.IRawDataHandler;
import org.eclipse.tml.protocol.lib.msgdef.NullMessageHandler;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;
import org.eclipse.tml.protocol.lib.msgdef.databeans.FixedSizeDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.IMsgDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.IteratableBlockDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.RawDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.VariableSizeDataBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolExtensionsReader
implements IExtensionConstants {
    public static ProtocolBean readProtocolImplDef(String protocolId) throws MalformedProtocolExtensionException {
        ProtocolBean bean = new ProtocolBean();
        bean.setProtocolId(protocolId);
        IConfigurationElement confElem = ProtocolExtensionsReader.getProtocolConfElem(protocolId);
        bean.setParentProtocol(ProtocolExtensionsReader.getImmediateProtocolParent(protocolId));
        bean.setBigEndianProtocol(Boolean.parseBoolean(confElem.getAttribute("isBigEndianProtocol")));
        try {
            Object initSeedObj = confElem.createExecutableExtension("initializer");
            if (!(initSeedObj instanceof IProtocolInit)) {
                throw new MalformedProtocolExtensionException("The protocol has not declared a valid initializer");
            }
            bean.setProtocolInitSeed((IProtocolInit)initSeedObj);
        }
        catch (CoreException e) {
            throw new MalformedProtocolExtensionException(e.getMessage(), e);
        }
        return bean;
    }

    public static Map<Long, ProtocolMsgDefinition> readMessageDefinitions(String protocolId) throws MalformedProtocolExtensionException {
        return ProtocolExtensionsReader.getAllProtocolMessages(ProtocolExtensionsReader.getAllParentProtocols(protocolId), true);
    }

    public static Collection<String> readServerMessages(String protocolId) throws MalformedProtocolExtensionException {
        return ProtocolExtensionsReader.getMessagesOrientations(ProtocolExtensionsReader.getAllParentProtocols(protocolId), "serverMessage");
    }

    public static Collection<String> readClientMessages(String protocolId) throws MalformedProtocolExtensionException {
        return ProtocolExtensionsReader.getMessagesOrientations(ProtocolExtensionsReader.getAllParentProtocols(protocolId), "clientMessage");
    }

    private static String getImmediateProtocolParent(String protocolId) {
        String parentId = null;
        IConfigurationElement protocolConfElem = ProtocolExtensionsReader.getProtocolConfElem(protocolId);
        if (protocolConfElem != null) {
            parentId = protocolConfElem.getAttribute("parentProtocol");
        }
        return parentId;
    }

    private static IConfigurationElement getProtocolConfElem(String protocolId) {
        IExtension[] allProtocolExtensions;
        IConfigurationElement returnElement = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint protocolExtPoint = registry.getExtensionPoint("org.eclipse.tml.protocol.protocolDefinition");
        IExtension[] iExtensionArray = allProtocolExtensions = protocolExtPoint.getExtensions();
        int n = allProtocolExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] protocolConfArray;
            IExtension protocolExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = protocolConfArray = protocolExtension.getConfigurationElements();
            int n3 = protocolConfArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String extensionProtocolId;
                IConfigurationElement protocolConf = iConfigurationElementArray[n4];
                if (protocolConf.getName().equals("protocol") && (extensionProtocolId = protocolConf.getAttribute("protocolId")).equals(protocolId)) {
                    returnElement = protocolConf;
                    break;
                }
                ++n4;
            }
            if (returnElement != null) break;
            ++n2;
        }
        return returnElement;
    }

    private static List<String> getAllParentProtocols(String protocolId) {
        ArrayList<String> allParents = new ArrayList<String>();
        allParents.add(protocolId);
        String aParent = protocolId;
        do {
            if ((aParent = ProtocolExtensionsReader.getImmediateProtocolParent(aParent)) == null) continue;
            allParents.add(aParent);
        } while (aParent != null);
        return allParents;
    }

    private static Map<Long, ProtocolMsgDefinition> getAllProtocolMessages(List<String> protocols, boolean readFields) throws MalformedProtocolExtensionException {
        HashMap<Long, ProtocolMsgDefinition> messageDefCollection = new HashMap<Long, ProtocolMsgDefinition>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint protocolMsgExtPoint = registry.getExtensionPoint("org.eclipse.tml.protocol.protocolMessage");
        IExtension[] allProtocolMsgExtensions = protocolMsgExtPoint.getExtensions();
        for (String protocol : protocols) {
            IExtension[] iExtensionArray = allProtocolMsgExtensions;
            int n = allProtocolMsgExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] protocolMsgConfArray;
                IExtension protocolMsgExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = protocolMsgConfArray = protocolMsgExtension.getConfigurationElements();
                int n3 = protocolMsgConfArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement protocolMsgConf = iConfigurationElementArray[n4];
                    String extensionProtocolId = protocolMsgConf.getAttribute("protocolId");
                    String extensionMsgCode = protocolMsgConf.getAttribute("messageCode");
                    if (protocol.equals(extensionProtocolId) && !messageDefCollection.containsKey(extensionMsgCode)) {
                        ProtocolExtensionsReader.readMsgDefToCollection(protocolMsgConf, messageDefCollection, readFields);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return messageDefCollection;
    }

    private static void readMsgDefToCollection(IConfigurationElement protocolMsgConf, Map<Long, ProtocolMsgDefinition> messageDefMap, boolean readFields) throws MalformedProtocolExtensionException {
        try {
            ProtocolMsgDefinition bean = new ProtocolMsgDefinition();
            long code = Long.decode(protocolMsgConf.getAttribute("messageCode"));
            String id = protocolMsgConf.getAttribute("messageId");
            boolean codeSigned = Boolean.parseBoolean(protocolMsgConf.getAttribute("isMessageCodeSigned"));
            int codeSize = Integer.decode(protocolMsgConf.getAttribute("messageCodeSizeInBytes"));
            IMessageHandler handler = null;
            if (protocolMsgConf.getAttribute("messageHandler") != null) {
                Object aObject = protocolMsgConf.createExecutableExtension("messageHandler");
                if (!(aObject instanceof IMessageHandler)) {
                    throw new MalformedProtocolExtensionException("Error at message declaration. The message handler must be an instance of IMessageHandler");
                }
                handler = (IMessageHandler)aObject;
            } else {
                handler = new NullMessageHandler();
            }
            ArrayList<IMsgDataBean> msgDataList = new ArrayList<IMsgDataBean>();
            if (readFields) {
                IConfigurationElement[] msgDataConfArray;
                IConfigurationElement[] iConfigurationElementArray = msgDataConfArray = protocolMsgConf.getChildren();
                int n = msgDataConfArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement msgDataConf = iConfigurationElementArray[n2];
                    IMsgDataBean msgData = ProtocolExtensionsReader.readMsgData(msgDataConf);
                    msgDataList.add(msgData);
                    ++n2;
                }
            }
            bean.setCode(code);
            bean.setId(id);
            bean.setMsgCodeSigned(codeSigned);
            bean.setMsgCodeSizeInBytes(codeSize);
            bean.setHandler(handler);
            bean.setMessageData(msgDataList);
            PluginProtocolModel model = PluginProtocolModel.getInstance();
            Collection<String> clientMsgs = model.getClientMessages(protocolMsgConf.getAttribute("protocolId"));
            Collection<String> serverMsgs = model.getServerMessages(protocolMsgConf.getAttribute("protocolId"));
            if (clientMsgs.contains(id)) {
                messageDefMap.put(code, bean);
            }
            if (serverMsgs.contains(id)) {
                messageDefMap.put(-code, bean);
            }
        }
        catch (CoreException coreException) {}
    }

    private static IMsgDataBean readMsgData(IConfigurationElement msgDataConf) throws MalformedProtocolExtensionException, CoreException {
        IMsgDataBean bean = null;
        if (msgDataConf.getName().equals("fixedSizeData")) {
            FixedSizeDataBean fixedBean = new FixedSizeDataBean();
            String fieldName = msgDataConf.getAttribute("fieldName");
            boolean isFieldSigned = Boolean.parseBoolean(msgDataConf.getAttribute("isFieldSigned"));
            int fieldSizeInBytes = Integer.decode(msgDataConf.getAttribute("fieldSizeInBytes"));
            String value = msgDataConf.getAttribute("value");
            fixedBean.setFieldName(fieldName);
            fixedBean.setFieldSigned(isFieldSigned);
            fixedBean.setFieldSizeInBytes(fieldSizeInBytes);
            if (value != null) {
                fixedBean.setValue(Integer.decode(value));
            }
            bean = fixedBean;
        } else if (msgDataConf.getName().equals("variableSizeData")) {
            VariableSizeDataBean varBean = new VariableSizeDataBean();
            String sizeFieldName = msgDataConf.getAttribute("sizeFieldName");
            boolean isSizeFieldSigned = Boolean.parseBoolean(msgDataConf.getAttribute("isSizeFieldSigned"));
            int sizeFieldSizeInBytes = Integer.decode(msgDataConf.getAttribute("sizeFieldSizeInBytes"));
            String valueFieldName = msgDataConf.getAttribute("valueFieldName");
            String charsetName = msgDataConf.getAttribute("charsetName");
            String value = msgDataConf.getAttribute("value");
            varBean.setSizeFieldName(sizeFieldName);
            varBean.setSizeFieldSigned(isSizeFieldSigned);
            varBean.setSizeFieldSizeInBytes(sizeFieldSizeInBytes);
            varBean.setValueFieldName(valueFieldName);
            varBean.setCharsetName(charsetName);
            if (value != null) {
                varBean.setValue(value);
            }
            bean = varBean;
        } else if (msgDataConf.getName().equals("rawDataHandler")) {
            RawDataBean rawBean = new RawDataBean();
            Object aObject = msgDataConf.createExecutableExtension("rawDataHandler");
            if (!(aObject instanceof IRawDataHandler)) {
                throw new MalformedProtocolExtensionException("Error at message declaration. The raw data handler must be an instance of IRawDataHandler");
            }
            rawBean.setHandler((IRawDataHandler)aObject);
            bean = rawBean;
        } else if (msgDataConf.getName().equals("iteratableBlock")) {
            IConfigurationElement[] internalElements;
            IteratableBlockDataBean iteratableBean = new IteratableBlockDataBean();
            String iterateOnField = msgDataConf.getAttribute("iterateOn");
            String iteratableBlockId = msgDataConf.getAttribute("iterableBlockId");
            ArrayList<IMsgDataBean> dataBeans = new ArrayList<IMsgDataBean>();
            iteratableBean.setIterateOnField(iterateOnField);
            iteratableBean.setId(iteratableBlockId);
            IConfigurationElement[] iConfigurationElementArray = internalElements = msgDataConf.getChildren();
            int n = internalElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement internal = iConfigurationElementArray[n2];
                IMsgDataBean internalBean = ProtocolExtensionsReader.readMsgData(internal);
                dataBeans.add(internalBean);
                ++n2;
            }
            iteratableBean.setDataBeans(dataBeans);
            bean = iteratableBean;
        } else {
            throw new MalformedProtocolExtensionException("Unkown data element");
        }
        return bean;
    }

    private static Collection<String> getMessagesOrientations(List<String> protocols, String messageOrientationElem) throws MalformedProtocolExtensionException {
        IExtension[] allMsgOrientationExtensions;
        HashSet<String> messageOrientations = new HashSet<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint msgOrientationExtPoint = registry.getExtensionPoint("org.eclipse.tml.protocol.protocolMessageOrientation");
        IExtension[] iExtensionArray = allMsgOrientationExtensions = msgOrientationExtPoint.getExtensions();
        int n = allMsgOrientationExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] allMsgOrientationConfElem;
            IExtension anExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = allMsgOrientationConfElem = anExtension.getConfigurationElements();
            int n3 = allMsgOrientationConfElem.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement aConfElem = iConfigurationElementArray[n4];
                if (aConfElem.getName().equals(messageOrientationElem)) {
                    String extPointProtocolId = aConfElem.getAttribute("protocolId");
                    String extPointMessageId = aConfElem.getAttribute("messageId");
                    if (protocols.contains(extPointProtocolId)) {
                        messageOrientations.add(extPointMessageId);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return messageOrientations;
    }
}

