/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics;

import java.io.DataInput;
import org.eclipse.tml.vncviewer.graphics.AbstractPaintStrategy;
import org.eclipse.tml.vncviewer.graphics.IPainterContext;
import org.eclipse.tml.vncviewer.network.RectHeader;

public class HexTilePaintStrategy
extends AbstractPaintStrategy {
    private static final int RAW = 1;
    private static final int BACKGROUND_SPECIFIED = 2;
    private static final int FOREGROUND_SPECIFIED = 4;
    private static final int ANY_SUBRECTS = 8;
    private static final int SUBRECTS_COLOURED = 16;
    protected int hextileBackground = 0;
    protected int hextileForeground = 0;

    public HexTilePaintStrategy(IPainterContext context) {
        super(context);
    }

    public void processRectangle(RectHeader rh, DataInput in) throws Exception {
        int x = rh.getX();
        int y = rh.getY();
        int width = rh.getWidth();
        int height = rh.getHeight();
        int ty = y;
        while (ty < y + height) {
            int th = Math.min(y + height - ty, 16);
            int tx = x;
            while (tx < x + width) {
                int tw = Math.min(x + width - tx, 16);
                this.processHextileSubrect(in, tx, ty, tw, th);
                tx += 16;
            }
            ty += 16;
        }
    }

    void processHextileSubrect(DataInput in, int x, int y, int width, int height) throws Exception {
        int subencoding = in.readUnsignedByte();
        if ((subencoding & 1) != 0) {
            this.getContext().processRectangle(new RectHeader(x, y, width, height, 0), in);
            return;
        }
        if ((subencoding & 2) != 0) {
            this.hextileBackground = this.getContext().readPixel(in);
        }
        this.getContext().fillRect(this.hextileBackground, x, y, width, height);
        if ((subencoding & 4) != 0) {
            this.hextileForeground = this.getContext().readPixel(in);
        }
        if ((subencoding & 8) == 0) {
            return;
        }
        boolean colored = (subencoding & 0x10) != 0;
        int subRectsCount = in.readUnsignedByte();
        int i = 0;
        while (i < subRectsCount) {
            int pix = this.hextileForeground;
            if (colored) {
                this.hextileForeground = pix = this.getContext().readPixel(in);
            }
            int position = in.readUnsignedByte();
            int size = in.readUnsignedByte();
            int subRectX = x + (position >> 4);
            int subRectY = y + (position & 0xF);
            int subRectWidth = (size >> 4) + 1;
            int subRectHeight = (size & 0xF) + 1;
            this.getContext().fillRect(pix, subRectX, subRectY, subRectWidth, subRectHeight);
            ++i;
        }
    }
}

