/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.statemachine;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.framework.device.DeviceUtils;
import org.eclipse.tml.framework.device.events.InstanceEvent;
import org.eclipse.tml.framework.device.events.InstanceEventManager;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.device.model.handler.IServiceHandler;
import org.eclipse.tml.framework.device.model.handler.ServiceHandler;
import org.eclipse.tml.framework.device.statemachine.StateMachine;
import org.eclipse.tml.framework.device.statemachine.StateMachineModel;
import org.eclipse.tml.framework.status.IStatusTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachineHandler {
    private IInstance instance;
    private StateMachineModel stmModel;
    private IStatusTransition transition = null;
    private boolean transitioning = false;

    public StateMachineHandler(IInstance instance) {
        this.instance = instance;
        IDeviceType device = DeviceUtils.getDeviceType(instance);
        List<IService> services = device.getServices();
        HashSet<IStatusTransition> transitions = new HashSet<IStatusTransition>();
        for (IService service : services) {
            transitions.addAll(service.getStatusTransitions());
        }
        StateMachine stm = new StateMachine(transitions);
        this.stmModel = new StateMachineModel(stm);
    }

    public IStatus runService(ServiceHandler svcHnd, IInstance instance, Map<Object, Object> arguments, String jobName, IProgressMonitor monitor) throws TmLException {
        IStatus status = Status.OK_STATUS;
        this.setTransitioning(true);
        this.transition = svcHnd.getService().getStatusTransitions(instance.getStatus());
        if (!this.transition.getStartId().equals(this.stmModel.getState())) {
            throw new TmLException();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(jobName, 1000);
        status = svcHnd.runService(instance, arguments, (IProgressMonitor)new SubProgressMonitor(monitor, 950));
        if (status.isOK()) {
            IServiceHandler parent = svcHnd.getParent();
            if (parent != null) {
                if (parent instanceof ServiceHandler) {
                    status = ((ServiceHandler)parent).updatingService(instance, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                } else {
                    parent.updatingService(instance);
                    monitor.worked(50);
                }
            } else {
                status = svcHnd.updatingService(instance, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
        }
        if (status.isOK()) {
            this.stmModel.transitionState(this.transition.getEndId());
        } else if (status.getSeverity() != 8) {
            this.stmModel.transitionState(this.transition.getHaltId());
        }
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_TRANSITIONED, instance));
        monitor.done();
        this.setTransitioning(false);
        return status;
    }

    public synchronized void setState(String dest) {
        this.stmModel.setState(dest);
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_TRANSITIONED, this.instance));
    }

    public String getState() {
        return this.stmModel.getState();
    }

    public IStatusTransition getCurrentStatusTransition() {
        return this.transition;
    }

    private synchronized void setTransitioning(boolean transitioning) {
        this.transitioning = transitioning;
    }

    public boolean isTransitioning() {
        return this.transitioning;
    }
}

