/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib.internal.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolHandshake;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientModel {
    private static ClientModel instance;
    private Map<ProtocolHandle, ProtocolEngine> runningEngines = new HashMap<ProtocolHandle, ProtocolEngine>();

    private ClientModel() {
    }

    public static ClientModel getInstance() {
        if (instance == null) {
            instance = new ClientModel();
        }
        return instance;
    }

    public ProtocolHandle requestStartProtocol(Map<Long, ProtocolMsgDefinition> allMessages, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolHandshake protocolInitializer, IProtocolExceptionHandler exceptionHandler, Boolean isBigEndianProtocol, String host, int port, Map<String, Object> parameters) {
        Integer retriesObj = (Integer)parameters.get("connectionRetries");
        int retries = retriesObj != null ? retriesObj : -1;
        ProtocolHandle handle = new ProtocolHandle();
        BasePlugin.logDebugMessage((String)"ClientModel", (String)("Creating a protocol engine to handle the protocol connection. Generated handle: " + handle + "."));
        ProtocolEngine eng = new ProtocolEngine(handle, protocolInitializer, allMessages, incomingMessages, outgoingMessages, exceptionHandler, isBigEndianProtocol, false, retries);
        eng.requestStart(host, port, parameters);
        BasePlugin.logDebugMessage((String)"ClientModel", (String)"Registering the protocol engine at Client Model");
        this.runningEngines.put(handle, eng);
        return handle;
    }

    public void requestStopProtocol(ProtocolHandle handle) {
        ProtocolEngine eng = this.runningEngines.get(handle);
        if (eng != null) {
            eng.requestStop();
            this.cleanStoppedProtocols();
            BasePlugin.logDebugMessage((String)"ClientModel", (String)"Unregistering the protocol engine from Client Model");
            this.runningEngines.remove(handle);
        }
    }

    public void requestRestartProtocol(ProtocolHandle handle) {
        ProtocolEngine eng = this.runningEngines.get(handle);
        if (eng != null) {
            eng.requestRestart();
        }
    }

    public void sendMessage(ProtocolHandle handle, ProtocolMessage message) {
        ProtocolEngine eng = this.runningEngines.get(handle);
        if (eng != null) {
            eng.requestSendMessage(message);
        }
    }

    public void cleanStoppedProtocols() {
        BasePlugin.logDebugMessage((String)"ClientModel", (String)"Removing all stopped protocol engines from Client Model.");
        Set<ProtocolHandle> keys = this.runningEngines.keySet();
        for (ProtocolHandle key : keys) {
            ProtocolEngine aEng = this.runningEngines.get(key);
            if (aEng.isConnected()) continue;
            aEng.dispose();
            keys.remove(key);
        }
    }

    public boolean isClientProtocolRunning(ProtocolHandle handle) {
        boolean isRunning = false;
        ProtocolEngine eng = this.runningEngines.get(handle);
        if (eng != null) {
            isRunning = eng.isRunning();
        }
        return isRunning;
    }
}

