/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.device.qemu.launcher;

import org.eclipse.core.runtime.IPath;
import org.eclipse.tml.device.qemu.QEmuPlugin;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.service.start.launcher.DefaultConnection;
import org.eclipse.tml.service.start.launcher.IConnection;
import org.eclipse.tml.service.start.launcher.IDeviceLauncher;

public class QEmuLauncher
implements IDeviceLauncher {
    public static final String EMULATOR_PID_FILE_NAME = "qemu.pid";
    public static final String SLASH = "\\";
    public IConnection connection;
    public int pid = 0;
    private IInstance instance;

    public QEmuLauncher(IInstance instance) {
        this.instance = instance;
        this.connection = new DefaultConnection();
        this.connection.setHost(instance.getProperties().getProperty("host"));
        this.connection.setDisplay(instance.getProperties().getProperty("display"));
        this.connection.setPort(Integer.parseInt(instance.getProperties().getProperty("port")));
    }

    public int getPID() {
        return this.pid;
    }

    public void setPID(int pid) {
        this.pid = pid;
    }

    public String getFileId() {
        IPath path = QEmuPlugin.getDefault().getStateLocation();
        String filePath = String.valueOf(path.addTrailingSeparator().toOSString()) + EMULATOR_PID_FILE_NAME;
        return filePath;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public String getLocation() {
        return String.valueOf(this.getWorkingDirectory()) + this.instance.getProperties().getProperty("QEmuBinaryName");
    }

    public String getToolArguments() {
        return this.buildEmulatorOptions();
    }

    public String getWorkingDirectory() {
        String installedDir = this.instance.getProperties().getProperty("InstalledDirectory");
        return installedDir.concat(SLASH);
    }

    private String buildEmulatorOptions() {
        String enableVNC;
        String additionalOptions;
        String emulatedMachine;
        String initrd;
        StringBuffer buffer = new StringBuffer();
        String kernelImage = this.instance.getProperties().getProperty("KernelImage");
        buffer.append(" -L . ");
        if (kernelImage != null && kernelImage != "") {
            buffer.append(" -kernel ");
            buffer.append(kernelImage);
        }
        if ((initrd = this.instance.getProperties().getProperty("InitialRAMDisk")) != null && initrd != "") {
            buffer.append(" -initrd ");
            buffer.append(initrd);
        }
        if ((emulatedMachine = this.instance.getProperties().getProperty("EmulatedMachine")) != null && emulatedMachine != "") {
            buffer.append(" -M ");
            buffer.append(emulatedMachine);
        }
        if ((additionalOptions = this.instance.getProperties().getProperty("AdditionalOptions")) != null && additionalOptions != "") {
            buffer.append(" ");
            buffer.append(additionalOptions);
            buffer.append(" ");
        }
        if ((enableVNC = this.instance.getProperties().getProperty("EnableVNC")) != null && Boolean.TRUE.toString().equals(enableVNC)) {
            buffer.append(" -vnc " + this.connection.getStringHost());
        }
        buffer.append(" -pidfile " + this.getFileId());
        return buffer.toString();
    }
}

