/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.events;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.tml.framework.device.events.IInstanceListener;
import org.eclipse.tml.framework.device.events.InstanceEvent;

public class InstanceEventManager
extends EventManager {
    private Collection<InstanceEvent> eventsToFire = Collections.synchronizedSet(new LinkedHashSet());
    private Runnable eventNotifierLoop = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (InstanceEventManager.this.isListenerAttached()) {
                if (InstanceEventManager.this.eventsToFire == null) continue;
                if (InstanceEventManager.this.eventsToFire.isEmpty()) {
                    Collection collection = InstanceEventManager.this.eventsToFire;
                    synchronized (collection) {
                        try {
                            InstanceEventManager.this.eventsToFire.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (InstanceEventManager.this.eventsToFire.isEmpty()) continue;
                InstanceEvent[] array = InstanceEventManager.this.eventsToFire.toArray(new InstanceEvent[InstanceEventManager.this.eventsToFire.size()]);
                InstanceEvent e = array[0];
                switch (e.getType()) {
                    case INSTANCE_CREATED: {
                        InstanceEventManager.this.fireInstanceCreated(e);
                        break;
                    }
                    case INSTANCE_DELETED: {
                        InstanceEventManager.this.fireInstanceDeleted(e);
                        break;
                    }
                    case INSTANCE_LOADED: {
                        InstanceEventManager.this.fireInstanceLoaded(e);
                        break;
                    }
                    case INSTANCE_UNLOADED: {
                        InstanceEventManager.this.fireInstanceUnloaded(e);
                        break;
                    }
                    case INSTANCE_UPDATED: {
                        InstanceEventManager.this.fireInstanceUpdated(e);
                        break;
                    }
                    case INSTANCE_TRANSITIONED: {
                        InstanceEventManager.this.fireInstanceTransitioned(e);
                    }
                }
                InstanceEventManager.this.eventsToFire.remove(e);
            }
        }
    };
    private static InstanceEventManager _instance;

    private InstanceEventManager() {
    }

    public static InstanceEventManager getInstance() {
        if (_instance == null) {
            _instance = new InstanceEventManager();
        }
        return _instance;
    }

    public void addInstanceListener(IInstanceListener listener) {
        boolean startThread = false;
        if (!this.isListenerAttached()) {
            startThread = true;
        }
        this.addListenerObject(listener);
        if (startThread) {
            new Thread(this.eventNotifierLoop, "Instance Event Manager").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(IInstanceListener listener) {
        this.removeListenerObject(listener);
        Collection<InstanceEvent> collection = this.eventsToFire;
        synchronized (collection) {
            this.eventsToFire.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(InstanceEvent event) {
        if (event.getType() == InstanceEvent.InstanceEventType.INSTANCE_ABOUT_TO_TRANSITION) {
            this.fireInstanceAboutToTransition(event);
        } else {
            this.eventsToFire.add(event);
            Collection<InstanceEvent> collection = this.eventsToFire;
            synchronized (collection) {
                this.eventsToFire.notify();
            }
        }
    }

    protected void fireInstanceCreated(final InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceCreated(event);
                }
            });
            ++i;
        }
    }

    protected void fireInstanceDeleted(final InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceDeleted(event);
                }
            });
            ++i;
        }
    }

    protected void fireInstanceLoaded(final InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceLoaded(event);
                }
            });
            ++i;
        }
    }

    protected void fireInstanceUnloaded(final InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceUnloaded(event);
                }
            });
            ++i;
        }
    }

    protected void fireInstanceUpdated(final InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceUpdated(event);
                }
            });
            ++i;
        }
    }

    protected void fireInstanceTransitioned(final InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceTransitioned(event);
                }
            });
            ++i;
        }
    }

    protected void fireInstanceAboutToTransition(final InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            final IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceAboutToTransition(event);
                }
            });
            ++i;
        }
    }
}

