/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.events.InstanceAdapter;
import org.eclipse.tml.framework.device.events.InstanceEvent;
import org.eclipse.tml.framework.device.events.InstanceEventManager;
import org.eclipse.tml.framework.device.manager.persistence.DeviceXmlReader;
import org.eclipse.tml.framework.device.manager.persistence.DeviceXmlWriter;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IInstanceRegistry;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceRegistry
implements IInstanceRegistry {
    private List<IInstance> instances = new ArrayList<IInstance>();
    private static InstanceRegistry _instance;

    private InstanceRegistry() {
        Collection<IInstance> loadedInstances = DeviceXmlReader.loadInstances();
        for (IInstance inst : loadedInstances) {
            this.addInstance(inst);
        }
        IWorkbench workbench = DevicePlugin.getDefault().getWorkbench();
        workbench.addWindowListener((IWindowListener)new WindowListener());
        InstanceAdapter listener = new InstanceAdapter(){

            public void instanceUpdated(InstanceEvent e) {
                DeviceXmlWriter.saveInstances();
            }
        };
        InstanceEventManager.getInstance().addInstanceListener(listener);
    }

    public static InstanceRegistry getInstance() {
        if (_instance == null) {
            _instance = new InstanceRegistry();
        }
        return _instance;
    }

    @Override
    public ImageDescriptor getImage() {
        return DevicePlugin.getDefault().getImageDescriptor("ICON_DEVICE");
    }

    @Override
    public List<IInstance> getInstances() {
        return this.instances;
    }

    @Override
    public void setInstances(List<IInstance> instance) {
        this.instances = instance;
    }

    @Override
    public void addInstance(IInstance instance) {
        this.instances.add(instance);
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_LOADED, instance));
    }

    @Override
    public void removeInstance(IInstance instance) {
        this.instances.remove(instance);
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UNLOADED, instance));
    }

    @Override
    public void clear() {
        this.instances.clear();
    }

    public List<IInstance> getInstancesByName(String name) {
        InstanceRegistry registry = InstanceRegistry.getInstance();
        List<IInstance> instanceList = registry.getInstances();
        ArrayList<IInstance> returnValue = new ArrayList<IInstance>();
        for (IInstance inst : instanceList) {
            if (!inst.getName().equals(name)) continue;
            returnValue.add(inst);
        }
        return returnValue;
    }

    private class WindowListener
    implements IWindowListener {
        private WindowListener() {
        }

        public void windowClosed(IWorkbenchWindow window) {
            DeviceXmlWriter.saveInstances();
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }
    }
}

