/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.manager;

import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.common.utilities.exception.ExceptionHandler;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.framework.device.events.InstanceEvent;
import org.eclipse.tml.framework.device.events.InstanceEventManager;
import org.eclipse.tml.framework.device.exception.DeviceExceptionHandler;
import org.eclipse.tml.framework.device.factory.InstanceRegistry;
import org.eclipse.tml.framework.device.manager.persistence.DeviceXmlWriter;
import org.eclipse.tml.framework.device.model.AbstractMobileInstance;
import org.eclipse.tml.framework.device.model.IDeviceLauncher;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IInstanceBuilder;
import org.eclipse.tml.framework.device.model.handler.IDeviceHandler;
import org.eclipse.tml.framework.device.model.handler.UndefinedDeviceHandler;
import org.eclipse.tml.framework.device.statemachine.StateMachineHandler;

public class InstanceManager {
    private static final String ELEMENT_DEVICE = "deviceType";
    private static final String ATTR_HANDLER = "handler";
    private static IInstance currentInstance;

    public static void setInstance(IInstance instance) {
        currentInstance = instance;
    }

    public static IInstance getCurrentInstance() {
        return currentInstance;
    }

    public static IDeviceLauncher createLauncher(IInstance instance) throws TmLException {
        IDeviceHandler deviceHandler = null;
        IDeviceLauncher launcher = null;
        try {
            IExtension fromPlugin = PluginUtils.getExtension((String)"org.eclipse.tml.deviceTypes", (String)instance.getDeviceTypeId());
            deviceHandler = (IDeviceHandler)PluginUtils.getExecutableAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATTR_HANDLER);
            launcher = deviceHandler.createDeviceLauncher(instance);
        }
        catch (CoreException coreException) {
            ExceptionHandler.showException((TmLException)DeviceExceptionHandler.exception(202));
        }
        return launcher;
    }

    public static IInstance createInstance(String name, String deviceId, String status, Properties properties) throws TmLException {
        IDeviceHandler deviceHandler = null;
        IInstance instance = null;
        try {
            IExtension fromPlugin = PluginUtils.getExtension((String)"org.eclipse.tml.deviceTypes", (String)deviceId);
            if (fromPlugin != null) {
                deviceHandler = (IDeviceHandler)PluginUtils.getExecutableAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATTR_HANDLER);
                if (deviceHandler == null) {
                    throw DeviceExceptionHandler.exception(202);
                }
            } else {
                deviceHandler = new UndefinedDeviceHandler();
            }
            instance = deviceHandler.createDeviceInstance(String.valueOf(name) + deviceId);
            instance.setDeviceTypeId(deviceId);
            instance.setName(name);
            if (fromPlugin != null) {
                ((AbstractMobileInstance)instance).setStateMachineHandler(new StateMachineHandler(instance));
                instance.setStatus(status);
            }
            instance.setProperties((Properties)properties.clone());
        }
        catch (CoreException coreException) {
            throw DeviceExceptionHandler.exception(202);
        }
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_CREATED, instance));
        return instance;
    }

    public static void deleteInstance(IInstance instance) {
        if (currentInstance == instance) {
            currentInstance = null;
        }
        InstanceRegistry registry = InstanceRegistry.getInstance();
        registry.removeInstance(instance);
        DeviceXmlWriter.saveInstances();
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_DELETED, instance));
    }

    public static void createProject(IDeviceType device, IInstanceBuilder projectBuilder, IProgressMonitor monitor) throws TmLException {
        IInstance inst = InstanceManager.createInstance(projectBuilder.getProjectName(), device.getId(), "OFF", projectBuilder.getProperties());
        if (currentInstance == null) {
            currentInstance = inst;
        }
        InstanceRegistry registry = InstanceRegistry.getInstance();
        registry.addInstance(inst);
        DeviceXmlWriter.saveInstances();
    }
}

