/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.tml.framework.device.factory.DeviceTypeRegistry;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.ui.internal.model.DeviceTypeCustomWizardPage;
import org.eclipse.tml.framework.device.ui.model.IDeviceTypeCustomWizardPage;
import org.eclipse.tml.framework.device.ui.wizard.DefaultDeviceTypeMenuWizardPage;
import org.eclipse.tml.framework.device.ui.wizard.NewDeviceMenuWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTypeCustomMenuWizardPageHandler {
    private NewDeviceMenuWizard wizard;
    private static final String WIZARD_PAGES_EXTENSION_POINT_ID = "org.eclipse.tml.device.ui.newDeviceWizardPages";
    private static final String XML_ELEMENT_WIZARD_PAGE = "wizardPage";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_OPERATION_CLASS = "operationClass";
    private static final String XML_ATTRIBUTE_PAGE_CLASS = "pageClass";
    private static final String XML_ELEMENT_DEVICE_TYPE = "deviceType";
    private static final String XML_ATTRIBUTE_DEVICE_TYPE_ID = "deviceTypeId";
    private static Map<String, ArrayList<IDeviceTypeCustomWizardPage>> customPages = new HashMap<String, ArrayList<IDeviceTypeCustomWizardPage>>();

    public DeviceTypeCustomMenuWizardPageHandler(NewDeviceMenuWizard wizard) {
        this.wizard = wizard;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        DeviceTypeCustomMenuWizardPageHandler.loadExtensionsSynchronized();
        ArrayList<IDeviceTypeCustomWizardPage> pages = customPages.get(this.wizard.getCurrentDeviceTypeId());
        if (pages == null) {
            return null;
        }
        if (currentPage instanceof DefaultDeviceTypeMenuWizardPage) {
            return pages.get(0).getPageClass();
        }
        int i = 0;
        while (i < pages.size() - 1) {
            IDeviceTypeCustomWizardPage page = pages.get(i);
            if (page.getPageClass().equals(currentPage)) {
                return pages.get(i + 1).getPageClass();
            }
            ++i;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage currentPage) {
        DeviceTypeCustomMenuWizardPageHandler.loadExtensionsSynchronized();
        if (currentPage instanceof DefaultDeviceTypeMenuWizardPage) {
            return null;
        }
        ArrayList<IDeviceTypeCustomWizardPage> pages = customPages.get(this.wizard.getCurrentDeviceTypeId());
        if (pages != null) {
            if (currentPage instanceof DefaultDeviceTypeMenuWizardPage) {
                return null;
            }
            int i = pages.size() - 1;
            while (i >= 0) {
                IDeviceTypeCustomWizardPage page = pages.get(i);
                if (page.getPageClass().equals(currentPage)) {
                    if (i == 0) {
                        return this.wizard.getPage(NewDeviceMenuWizard.DEFAULT_PAGE_ID);
                    }
                    return pages.get(i - 1).getPageClass();
                }
                --i;
            }
        }
        return null;
    }

    private static synchronized void loadExtensionsSynchronized() {
        if (!customPages.isEmpty()) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(WIZARD_PAGES_EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            if (extensions != null) {
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        IConfigurationElement element = elements[j];
                        if (element.getName().equals(XML_ELEMENT_WIZARD_PAGE)) {
                            String id = element.getAttribute(XML_ATTRIBUTE_ID);
                            IRunnableWithProgress operationClass = null;
                            try {
                                IWizardPage pageClass = (IWizardPage)element.createExecutableExtension(XML_ATTRIBUTE_PAGE_CLASS);
                                if (element.getAttribute(XML_ATTRIBUTE_OPERATION_CLASS) != null) {
                                    operationClass = (IRunnableWithProgress)element.createExecutableExtension(XML_ATTRIBUTE_OPERATION_CLASS);
                                }
                                DeviceTypeCustomWizardPage customPage = new DeviceTypeCustomWizardPage(id, pageClass, operationClass);
                                IConfigurationElement[] children = element.getChildren();
                                int k = 0;
                                while (k < children.length) {
                                    IConfigurationElement childElement = children[k];
                                    if (childElement.getName().equals(XML_ELEMENT_DEVICE_TYPE)) {
                                        ArrayList<Object> list;
                                        String deviceTypeId = childElement.getAttribute(XML_ATTRIBUTE_DEVICE_TYPE_ID);
                                        if (customPages.containsKey(deviceTypeId)) {
                                            list = customPages.get(deviceTypeId);
                                            list.add(customPage);
                                        } else {
                                            list = new ArrayList();
                                            list.add(customPage);
                                            customPages.put(deviceTypeId, list);
                                        }
                                    }
                                    ++k;
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            for (String deviceTypeId : DeviceTypeRegistry.getInstance().getDeviceTypeIds()) {
                ArrayList<IDeviceTypeCustomWizardPage> list = customPages.get(deviceTypeId);
                ArrayList<IDeviceTypeCustomWizardPage> superList = DeviceTypeCustomMenuWizardPageHandler.getSuperClassWizardPages(deviceTypeId);
                if (list != null) {
                    if (superList == null) continue;
                    list.addAll(0, superList);
                    continue;
                }
                if (superList == null) continue;
                list = new ArrayList();
                list.addAll(superList);
                customPages.put(deviceTypeId, list);
            }
        }
    }

    private static ArrayList<IDeviceTypeCustomWizardPage> getSuperClassWizardPages(String deviceTypeId) {
        String superClassDeviceTypeId;
        IDeviceType currentDeviceType;
        ArrayList<IDeviceTypeCustomWizardPage> existPages;
        ArrayList<IDeviceTypeCustomWizardPage> pages = new ArrayList<IDeviceTypeCustomWizardPage>();
        if (customPages != null && (existPages = customPages.get(deviceTypeId)) != null && (currentDeviceType = DeviceTypeRegistry.getInstance().getDeviceTypeById(deviceTypeId)) != null && (superClassDeviceTypeId = currentDeviceType.getSuperClass()) != null) {
            pages.addAll(0, DeviceTypeCustomMenuWizardPageHandler.getSuperClassWizardPages(superClassDeviceTypeId));
            ArrayList<IDeviceTypeCustomWizardPage> superPages = customPages.get(superClassDeviceTypeId);
            int startingIndex = 0;
            if (superPages != null) {
                for (IDeviceTypeCustomWizardPage superCustomWizardPage : superPages) {
                    if (DeviceTypeCustomMenuWizardPageHandler.isPageExists(superCustomWizardPage.getId(), existPages)) continue;
                    pages.add(startingIndex++, superCustomWizardPage);
                }
            }
        }
        return pages;
    }

    private static boolean isPageExists(String pageId, ArrayList<IDeviceTypeCustomWizardPage> list) {
        if (list != null) {
            for (IDeviceTypeCustomWizardPage deviceTypeCustomWizardPage : list) {
                if (!deviceTypeCustomWizardPage.getId().equals(pageId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canFinish() {
        DeviceTypeCustomMenuWizardPageHandler.loadExtensionsSynchronized();
        ArrayList<IDeviceTypeCustomWizardPage> pages = customPages.get(this.wizard.getCurrentDeviceTypeId());
        if (pages != null) {
            for (IDeviceTypeCustomWizardPage customWizardPageDefinition : pages) {
                if (customWizardPageDefinition.getPageClass().isPageComplete()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean performFinish() {
        DeviceTypeCustomMenuWizardPageHandler.loadExtensionsSynchronized();
        ArrayList<IDeviceTypeCustomWizardPage> pages = customPages.get(this.wizard.getCurrentDeviceTypeId());
        if (pages == null) {
            return true;
        }
        ArrayList<IRunnableWithProgress> operations = new ArrayList<IRunnableWithProgress>();
        for (IDeviceTypeCustomWizardPage page : pages) {
            IRunnableWithProgress operationClass = page.getOperationClass();
            if (operationClass == null) continue;
            operations.add(operationClass);
        }
        for (IRunnableWithProgress runnableWithProgress : operations) {
            try {
                this.wizard.getContainer().run(false, true, runnableWithProgress);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

