/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics.swt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.config.VNCConfiguration;
import org.eclipse.tml.vncviewer.network.VNCKeyEvent;
import org.eclipse.tml.vncviewer.network.VNCMouseEvent;
import org.osgi.framework.Bundle;

public class SWTVNCEventTranslator {
    private static boolean shiftPressed = false;
    private static boolean buttonPressed = false;
    private static Hashtable<Integer, Integer> swtToKeysymCodes;

    private static Properties loadPropertiesFile(String filename) {
        Properties properties = new Properties();
        File propFile = new File(filename);
        try {
            properties.load(new FileInputStream(propFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    private static Properties loadDefaultPropertiesFile(String filename) {
        Properties properties = new Properties();
        Bundle pluginBundle = VNCViewerPlugin.getDefault().getBundle();
        URL vncViewerConf = pluginBundle.getResource(filename);
        try {
            InputStream vncViewerConfStream = vncViewerConf.openStream();
            properties.load(vncViewerConfStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static void initKeysyms() {
        Properties conf = VNCConfiguration.getConfigurationProperties();
        String swtkeysymsFile = conf.getProperty("KEYSYM_SWT_PROPERTIES_FILE");
        String keysymsFile = conf.getProperty("KEYSYM_PROPERTIES_FILE");
        String swtkeysFile = conf.getProperty("SWTKEYS_PROPERTIES_FILE");
        Properties keysymSwt = SWTVNCEventTranslator.loadDefaultPropertiesFile(swtkeysymsFile);
        Properties keysyms = SWTVNCEventTranslator.loadDefaultPropertiesFile(keysymsFile);
        Properties swtkeys = SWTVNCEventTranslator.loadDefaultPropertiesFile(swtkeysFile);
        swtToKeysymCodes = new Hashtable();
        Enumeration<Object> swtcodes = keysymSwt.keys();
        while (swtcodes.hasMoreElements()) {
            String key = (String)swtcodes.nextElement();
            Integer swtCode = new Integer(swtkeys.getProperty(key));
            Integer keysymCode = Integer.decode(keysyms.getProperty(keysymSwt.getProperty(key)));
            swtToKeysymCodes.put(swtCode, keysymCode);
        }
    }

    public static VNCMouseEvent getMouseEvent(Event swtEvent) {
        int eventType = -1;
        switch (swtEvent.type) {
            case 4: {
                eventType = VNCMouseEvent.MOUSE_UP;
                buttonPressed = false;
                break;
            }
            case 3: {
                eventType = VNCMouseEvent.MOUSE_DOWN;
                buttonPressed = true;
                break;
            }
            case 5: {
                eventType = VNCMouseEvent.MOUSE_MOVE;
                break;
            }
        }
        return new VNCMouseEvent(swtEvent.button, eventType, swtEvent.x, swtEvent.y, buttonPressed);
    }

    public static VNCKeyEvent getKeyEvent(Event swtEvent) {
        boolean pressed;
        SWTVNCEventTranslator.initKeysyms();
        if (swtEvent.keyCode == 131072) {
            shiftPressed = swtEvent.type == 1;
        }
        int keysym = SWTVNCEventTranslator.getKeysym(swtEvent.keyCode);
        boolean bl = pressed = swtEvent.type == 1;
        if (!shiftPressed) {
            return new VNCKeyEvent(keysym, pressed);
        }
        return new VNCKeyEvent(swtEvent.character, pressed);
    }

    public static int getKeysym(int swtKeyCode) {
        Integer keysymObj = swtToKeysymCodes.get(new Integer(swtKeyCode));
        int keysym = keysymObj != null ? keysymObj : swtKeyCode;
        return keysym;
    }
}

