/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network;

import org.eclipse.tml.vncviewer.exceptions.ProtoClientException;
import org.eclipse.tml.vncviewer.network.IVNCPainter;
import org.eclipse.tml.vncviewer.network.VNCProtocol;

public class VNCProtocol38
extends VNCProtocol {
    static final String RFB_VERSION = "RFB 003.008\n";
    static final int HANDSHAKE_MESSAGE_SIZE = 12;

    public VNCProtocol38(IVNCPainter vncPainter) {
        this.setVncPainter(vncPainter);
    }

    protected void compareVersion(byte[] b) throws Exception {
        if (!new String(b).equals(RFB_VERSION)) {
            throw new ProtoClientException("Wrong protocol version.");
        }
    }

    private void handshakeFail() throws Exception {
        String failReason = "";
        int failReasonLength = this.in.readInt();
        int j = 0;
        while (j < failReasonLength) {
            failReason = String.valueOf(failReason) + this.in.readByte();
            ++j;
        }
        throw new Exception("Connection failed: " + failReason);
    }

    protected void handShake() throws Exception {
        byte[] b = new byte[12];
        this.in.readFully(b, 0, 12);
        this.compareVersion(b);
        this.out.write(b);
        int secTypesNumber = this.in.readByte();
        if (secTypesNumber > 0) {
            int[] rfbSecTypes = new int[secTypesNumber];
            int i = 0;
            while (i < secTypesNumber) {
                rfbSecTypes[i] = this.in.readByte();
                ++i;
            }
            this.out.write(1);
        } else {
            this.handshakeFail();
        }
        int handshakeOK = this.in.readInt();
        if (handshakeOK != 0) {
            this.handshakeFail();
        }
    }
}

