/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.standalone;

import java.util.Properties;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.graphics.swt.SWTRemoteDisplay;

public class StandaloneVNCViewer {
    private static Canvas canvas;
    private static int WINDOW_WIDTH;
    private static int WINDOW_HEIGHT;
    private static String host;
    private static int port;

    static {
        WINDOW_WIDTH = 700;
        WINDOW_HEIGHT = 500;
        host = "127.0.0.1";
        port = 5900;
    }

    public static void addKeyEventListener(Composite parent) {
        final SWTRemoteDisplay vncswt = new SWTRemoteDisplay(parent, new Properties());
        final Display display = parent.getDisplay();
        try {
            vncswt.start(null);
        }
        catch (Exception exception) {
            VNCViewerPlugin.log(StandaloneVNCViewer.class).error("The viewer can not be started.");
        }
        canvas = vncswt.getCanvas();
        canvas.setFocus();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                final Event e = event;
                display.syncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Canvas canvas = vncswt.getCanvas();
                        synchronized (canvas) {
                            try {
                                vncswt.keyEvent(e);
                                vncswt.updateScreen();
                            }
                            catch (Exception exception) {
                                VNCViewerPlugin.log(StandaloneVNCViewer.class).error("VNC View error on key event.");
                            }
                            canvas.redraw();
                        }
                    }
                });
            }
        };
        canvas.addListener(1, listener);
    }

    public static void updateScreenLoop(Composite parent) {
        SWTRemoteDisplay vncswt = new SWTRemoteDisplay(parent, new Properties());
        try {
            vncswt.start(null);
        }
        catch (Exception exception) {
            VNCViewerPlugin.log(StandaloneVNCViewer.class).error("The viewer can not be started.");
        }
        while (!parent.isDisposed()) {
            try {
                vncswt.updateScreen();
                vncswt.wait(500L);
            }
            catch (Exception exception) {
                VNCViewerPlugin.log(StandaloneVNCViewer.class).error("Error on Loop test.");
            }
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        if (args.length != 2) {
            VNCViewerPlugin.log(StandaloneVNCViewer.class).error("[host] [port] expected.");
            return;
        }
        host = args[0];
        port = Integer.valueOf(args[1]);
        shell.setBounds(0, 0, WINDOW_WIDTH, WINDOW_HEIGHT);
        shell.open();
        StandaloneVNCViewer.updateScreenLoop((Composite)shell);
        display.dispose();
    }
}

