/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view.provider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.model.IDevice;
import org.eclipse.tml.framework.device.model.IDeviceRegistry;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.status.IStatusTransition;

public class DeviceLabelProvider
extends LabelProvider {
    private Map imageCache = new HashMap(11);

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof IDeviceRegistry) {
            descriptor = ((IDeviceRegistry)element).getImage();
        } else if (element instanceof IDevice) {
            descriptor = ((IDevice)element).getImage();
        } else if (element instanceof IService) {
            descriptor = ((IService)element).getImage();
        } else if (element instanceof IStatusTransition) {
            descriptor = DevicePlugin.getDefault().getImageDescriptor("ICON_BOOK");
        } else {
            throw this.unknownElement(element);
        }
        Image image = (Image)this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof IDeviceRegistry) {
            return "Device Registry";
        }
        if (element instanceof IDevice) {
            if (((IDevice)element).getName() == null) {
                return "Device";
            }
            return String.valueOf(((IDevice)element).getName()) + "(" + ((IDevice)element).getId() + ")";
        }
        if (element instanceof IService) {
            return ((IService)element).getName();
        }
        if (element instanceof IStatusTransition) {
            return ((IStatusTransition)element).toString();
        }
        throw this.unknownElement(element);
    }

    public void dispose() {
        Iterator i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
        this.imageCache.clear();
    }

    protected RuntimeException unknownElement(Object element) {
        return new RuntimeException("Unknown type of element in tree of type " + element.getClass().getName());
    }
}

