/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view.provider;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tml.framework.device.manager.DeviceManager;
import org.eclipse.tml.framework.device.model.IDevice;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IInstanceRegistry;
import org.eclipse.tml.framework.status.LabelStatus;

public class InstanceContentProvider
implements ITreeContentProvider {
    private static Object[] EMPTY_ARRAY = new Object[0];
    protected TreeViewer viewer;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        if (oldInput != null) {
            this.removeListenerFrom((IInstanceRegistry)oldInput);
        }
        if (newInput != null) {
            this.addListenerTo((IInstanceRegistry)newInput);
        }
    }

    protected void removeListenerFrom(IInstanceRegistry box) {
    }

    protected void addListenerTo(IInstanceRegistry box) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IInstanceRegistry) {
            IInstanceRegistry registry = (IInstanceRegistry)parentElement;
            return registry.getInstances().toArray();
        }
        if (parentElement instanceof IInstance) {
            IInstance instance = (IInstance)parentElement;
            LinkedList<Object> child = new LinkedList<Object>();
            IDevice device = DeviceManager.getInstance().getDevice(instance);
            if (device != null) {
                child.add(device);
                child.add(new LabelStatus(instance, instance.getStatus()));
                Properties properties = instance.getProperties();
                child.add(properties);
            }
            return child.toArray();
        }
        if (parentElement instanceof Properties) {
            Properties properties = (Properties)parentElement;
            LinkedList<String> child = new LinkedList<String>();
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = properties.getProperty(key);
                child.add(String.valueOf(key) + " = " + value);
            }
            return child.toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }
}

