/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics.swt;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tml.vncviewer.config.IPropertiesFileHandler;
import org.eclipse.tml.vncviewer.network.VNCKeyEvent;
import org.eclipse.tml.vncviewer.network.VNCMouseEvent;

public class SWTVNCEventTranslator {
    private boolean shiftPressed = false;
    private boolean buttonPressed = false;
    private Hashtable<Integer, Integer> swtToKeysymCodes;
    private Properties configProperties;
    private IPropertiesFileHandler propertiesFileHandler;

    public SWTVNCEventTranslator(Properties configProperties, IPropertiesFileHandler propertiesFileHandler) {
        this.configProperties = configProperties;
        this.propertiesFileHandler = propertiesFileHandler;
        this.initKeysyms();
    }

    public void initKeysyms() {
        String swtkeysymsFile = this.configProperties.getProperty("KEYSYM_SWT_PROPERTIES_FILE");
        String keysymsFile = this.configProperties.getProperty("KEYSYM_PROPERTIES_FILE");
        String swtkeysFile = this.configProperties.getProperty("SWTKEYS_PROPERTIES_FILE");
        Properties keysymSwt = this.propertiesFileHandler.loadPropertiesFile(swtkeysymsFile);
        Properties keysyms = this.propertiesFileHandler.loadPropertiesFile(keysymsFile);
        Properties swtkeys = this.propertiesFileHandler.loadPropertiesFile(swtkeysFile);
        this.swtToKeysymCodes = new Hashtable();
        Enumeration<Object> swtcodes = keysymSwt.keys();
        while (swtcodes.hasMoreElements()) {
            String key = (String)swtcodes.nextElement();
            Integer swtCode = new Integer(swtkeys.getProperty(key));
            Integer keysymCode = Integer.decode(keysyms.getProperty(keysymSwt.getProperty(key)));
            this.swtToKeysymCodes.put(swtCode, keysymCode);
        }
    }

    public VNCMouseEvent getMouseEvent(Event swtEvent) {
        int eventType = -1;
        switch (swtEvent.type) {
            case 4: {
                eventType = VNCMouseEvent.MOUSE_UP;
                this.buttonPressed = false;
                break;
            }
            case 3: {
                eventType = VNCMouseEvent.MOUSE_DOWN;
                this.buttonPressed = true;
                break;
            }
            case 5: {
                eventType = VNCMouseEvent.MOUSE_MOVE;
                break;
            }
        }
        return new VNCMouseEvent(swtEvent.button, eventType, swtEvent.x, swtEvent.y, this.buttonPressed);
    }

    public VNCKeyEvent getKeyEvent(Event swtEvent) {
        boolean pressed;
        if (swtEvent.keyCode == 131072) {
            this.shiftPressed = swtEvent.type == 1;
        }
        int keysym = this.getKeysym(swtEvent.keyCode);
        boolean bl = pressed = swtEvent.type == 1;
        if (!this.shiftPressed) {
            return new VNCKeyEvent(keysym, pressed);
        }
        return new VNCKeyEvent(swtEvent.character, pressed);
    }

    public int getKeysym(int swtKeyCode) {
        Integer keysymObj = this.swtToKeysymCodes.get(new Integer(swtKeyCode));
        int keysym = keysymObj != null ? keysymObj : swtKeyCode;
        return keysym;
    }
}

