/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.network.VNCProtocol;

class Consumer
implements Runnable {
    DataInputStream in;
    VNCProtocol vncProtocol;
    private volatile boolean running = false;

    public Consumer(DataInputStream in, VNCProtocol vnc) {
        this.in = in;
        this.vncProtocol = vnc;
    }

    public void run() {
        byte b = 0;
        this.setRunning(true);
        block8: while (this.running) {
            try {
                b = this.in.readByte();
            }
            catch (EOFException eOFException) {
                VNCViewerPlugin.log(VNCProtocol.class).error("Message Type read error - End of file not expected.");
                this.setRunning(false);
                break;
            }
            catch (IOException iOException) {
                VNCViewerPlugin.log(VNCProtocol.class).error("Message Type read error.");
                this.setRunning(false);
                break;
            }
            switch (b) {
                case 0: {
                    try {
                        this.vncProtocol.fbUpdate();
                    }
                    catch (Exception e) {
                        VNCViewerPlugin.log(VNCProtocol.class).error("Framebuffer update error: " + e.getMessage());
                        this.setRunning(false);
                    }
                    continue block8;
                }
                default: {
                    VNCViewerPlugin.log(VNCProtocol.class).error("Message type is not a framebuffer update.");
                    this.setRunning(false);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }
}

