/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network;

import org.eclipse.tml.vncviewer.exceptions.ProtoClientException;
import org.eclipse.tml.vncviewer.network.IVNCPainter;
import org.eclipse.tml.vncviewer.network.VNCProtocol;

public class VNCProtocol37
extends VNCProtocol {
    static final String RFB_VERSION = "RFB 003.007\n";
    static final int HANDSHAKE_MESSAGE_SIZE = 12;

    public VNCProtocol37(IVNCPainter vncPainter) {
        this.setVncPainter(vncPainter);
    }

    protected void compareVersion(byte[] b) throws Exception {
        String serverVersion = new String(b);
        boolean versionOk = false;
        if (serverVersion.equals(RFB_VERSION)) {
            versionOk = true;
        } else if (serverVersion.length() == RFB_VERSION.length() && serverVersion.subSequence(0, 10).equals(RFB_VERSION.substring(0, 10)) && serverVersion.charAt(10) > RFB_VERSION.charAt(10)) {
            versionOk = true;
        }
        if (!versionOk) {
            throw new ProtoClientException("Wrong protocol version.");
        }
    }

    private void handshakeFail() throws Exception {
        String failReason = "";
        int failReasonLength = this.in.readInt();
        int j = 0;
        while (j < failReasonLength) {
            failReason = String.valueOf(failReason) + this.in.readByte();
            ++j;
        }
        throw new Exception("Connection failed: " + failReason);
    }

    protected void handShake() throws Exception {
        byte[] b = new byte[12];
        byte[] ver37 = new byte[]{82, 70, 66, 32, 48, 48, 51, 46, 48, 48, 55, 10};
        this.in.readFully(b, 0, 12);
        this.compareVersion(b);
        this.out.write(ver37);
        int secTypesNumber = this.in.readByte();
        if (secTypesNumber > 0) {
            int[] rfbSecTypes = new int[secTypesNumber];
            int i = 0;
            while (i < secTypesNumber) {
                rfbSecTypes[i] = this.in.readByte();
                ++i;
            }
            this.out.write(1);
        } else {
            this.handshakeFail();
        }
    }
}

