/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.dstore.old;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.internal.extra.DomainEvent;
import org.eclipse.dstore.extra.internal.extra.IDomainListener;
import org.eclipse.rse.connectorservice.dstore.util.ICommunicationsDiagnosticFactory;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.dstore.universal.miners.IUniversalDataStoreConstants;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DownloadListener
implements IDomainListener,
ICommunicationsListener,
IUniversalDataStoreConstants {
    private DataElement _status;
    private Shell _shell;
    private IProgressMonitor _monitor;
    private DataStore _dataStore;
    private File _localFile;
    private Display _display;
    private boolean _networkDown = false;
    private boolean _isDone = false;
    private boolean _isCancelled = false;
    private long _totalBytesNotified = 0L;
    private long _totalLength;
    private static SystemMessage _percentMsg = RSEUIPlugin.getPluginMessage((String)"RSEG1290");

    public DownloadListener(Shell shell, IProgressMonitor monitor, IConnectorService system, DataElement status, File localFile, String remotePath, long totalLength) {
        this._shell = shell;
        this._monitor = monitor;
        this._status = status;
        this._totalLength = totalLength;
        this._display = Display.getCurrent();
        if (this._status == null) {
            System.out.println("Status is null!");
        }
        this._dataStore = this._status.getDataStore();
        system.addCommunicationsListener((ICommunicationsListener)this);
        this._dataStore.getDomainNotifier().addDomainListener((IDomainListener)this);
        this._localFile = localFile;
        if (monitor != null) {
            while (this._display != null && this._display.readAndDispatch()) {
            }
        }
        if (this._status.getValue().equals("done")) {
            this.updateDownloadState();
            this.setDone(true);
        }
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public DataElement getStatus() {
        return this._status;
    }

    public boolean listeningTo(DomainEvent event) {
        if (this._status == null) {
            return false;
        }
        return this._status == event.getParent();
    }

    public void domainChanged(DomainEvent event) {
        if (this._status.getValue().equals("done")) {
            if (this._status == event.getParent()) {
                this.setDone(true);
            }
        } else {
            this.updateDownloadState();
        }
    }

    private void updateDownloadState() {
        long currentLength;
        long delta;
        if (this._monitor != null && (delta = (currentLength = this._localFile.length()) - this._totalBytesNotified) > 0L) {
            this._monitor.worked((int)delta);
            try {
                long percent = currentLength * 100L / this._totalLength;
                StringBuffer current = new StringBuffer();
                current.append(currentLength / 1024L);
                current.append(" KB");
                StringBuffer total = new StringBuffer();
                total.append(this._totalLength / 1024L);
                total.append(" KB");
                StringBuffer percentBuf = new StringBuffer();
                percentBuf.append(percent);
                percentBuf.append("%");
                _percentMsg.makeSubstitution((Object)current, (Object)total, (Object)percentBuf);
                this._monitor.subTask(_percentMsg.getLevelOneText());
                while (this._display != null && this._display.readAndDispatch()) {
                }
            }
            catch (Exception exception) {}
            this._totalBytesNotified = currentLength;
        }
        if (!this._status.getDataStore().getStatus().getName().equals("okay")) {
            this._networkDown = true;
        }
    }

    public void setDone(boolean done) {
        this._isDone = done;
        if (done) {
            this.updateDownloadState();
            this._status.getDataStore().getDomainNotifier().removeDomainListener((IDomainListener)this);
        }
    }

    public Shell getShell() {
        return this._shell;
    }

    public boolean wasCancelled() {
        return this._isCancelled;
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        if (e.getState() == 5) {
            this._networkDown = true;
        }
    }

    public boolean isPassiveCommunicationsListener() {
        return true;
    }

    public DataElement waitForUpdate() throws InterruptedException {
        return this.waitForUpdate(null, 0);
    }

    public DataElement waitForUpdate(ICommunicationsDiagnosticFactory factory) throws InterruptedException {
        return this.waitForUpdate(factory, 0);
    }

    /*
     * Unable to fully structure code
     */
    public DataElement waitForUpdate(ICommunicationsDiagnosticFactory factory, int wait) throws InterruptedException {
        block13: {
            display = this._display;
            if (wait <= 0) {
                // empty if block
            }
            if (display == null) ** GOTO lbl40
            if (this._shell == null || this._shell.isDisposed()) {
                this._shell = Display.getDefault().getActiveShell();
            }
            while (!(this._isDone || this._isCancelled || this._networkDown)) {
                while (display.readAndDispatch()) {
                }
                if (this._monitor != null && this._monitor.isCanceled()) {
                    this.cancelDownload();
                    this._isCancelled = true;
                    this.setDone(true);
                } else if (this._networkDown) {
                    this._isCancelled = true;
                    this.setDone(true);
                    throw new InterruptedException();
                }
                if (this.getStatus().getAttribute(2).equals("done")) {
                    this.setDone(true);
                    continue;
                }
                Thread.sleep(100L);
                this.updateDownloadState();
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                if (this._monitor != null && this._monitor.isCanceled()) {
                    this.cancelDownload();
                    this._isCancelled = true;
                    this.setDone(true);
                } else if (this._networkDown) {
                    this._isCancelled = true;
                    this.setDone(true);
                    throw new InterruptedException();
                }
                if (this.getStatus().getAttribute(2).equals("done")) {
                    this.setDone(true);
                    continue;
                }
                Thread.sleep(100L);
                this.updateDownloadState();
lbl40:
                // 3 sources

                ** while (!this._isDone && !this._isCancelled && !this._networkDown)
            }
        }
        return this._status;
    }

    public void cancelDownload() {
        DataElement status = this._status;
        if (status != null) {
            DataElement cmdDescriptor;
            DataElement command = status.getParent();
            DataStore dataStore = command.getDataStore();
            DataElement cancelDescriptor = dataStore.localDescriptorQuery(cmdDescriptor = command.getDescriptor(), "C_CANCEL");
            if (cancelDescriptor != null) {
                dataStore.command(cancelDescriptor, command);
            }
            this._localFile.delete();
        }
        if (this._monitor != null) {
            this._monitor.done();
        }
    }
}

