/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners;

import java.io.File;
import org.eclipse.rse.dstore.universal.miners.ServerLogger;

public class UniversalServerUtilities {
    private static String _userPreferencesDirectory = null;

    static {
        new ServerLogger(UniversalServerUtilities.getUserPreferencesDirectory());
    }

    public static String getUserPreferencesDirectory() {
        if (_userPreferencesDirectory == null) {
            File dirFile;
            _userPreferencesDirectory = System.getProperty("user.home");
            String clientUserID = System.getProperty("client.username");
            clientUserID = clientUserID == null || clientUserID.equals("") ? "" : String.valueOf(clientUserID) + File.separator;
            if (_userPreferencesDirectory.length() == 0 || _userPreferencesDirectory.charAt(_userPreferencesDirectory.length() - 1) != File.separatorChar) {
                _userPreferencesDirectory = String.valueOf(_userPreferencesDirectory) + File.separator;
            }
            if (!(dirFile = new File(_userPreferencesDirectory = String.valueOf(_userPreferencesDirectory) + ".eclipse" + File.separator + "RSE" + File.separator + clientUserID)).exists()) {
                dirFile.mkdirs();
            }
        }
        return _userPreferencesDirectory;
    }

    public static void logInfo(String minerName, String message) {
        ServerLogger.logInfo(minerName, message);
    }

    public static void logWarning(String minerName, String message) {
        ServerLogger.logWarning(minerName, message);
    }

    public static void logError(String minerName, String message, Throwable exception) {
        ServerLogger.logError(minerName, message, exception);
    }

    public static void logDebugMessage(String minerName, String message) {
        ServerLogger.logDebugMessage(minerName, message);
    }
}

