/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.view;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.model.ISystemNewConnectionWizardPage;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.files.ui.actions.SystemFileUpdateFilterAction;
import org.eclipse.rse.files.ui.actions.SystemNewFileAction;
import org.eclipse.rse.files.ui.actions.SystemNewFileFilterAction;
import org.eclipse.rse.files.ui.actions.SystemNewFolderAction;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.view.SubSystemConfigurationAdapter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;

public class RemoteFileSubSystemConfigurationAdapter
extends SubSystemConfigurationAdapter {
    SystemNewFileFilterAction _newFileFilterAction;
    SystemFileUpdateFilterAction _changeFilerAction;
    Vector _additionalActions;

    public ISystemNewConnectionWizardPage[] getNewConnectionWizardPages(ISubSystemConfiguration factory, IWizard wizard) {
        ISystemNewConnectionWizardPage[] basepages = super.getNewConnectionWizardPages(factory, wizard);
        return basepages;
    }

    protected IAction getNewFilterPoolFilterAction(ISubSystemConfiguration factory, ISystemFilterPool selectedPool, Shell shell) {
        if (this._newFileFilterAction == null) {
            this._newFileFilterAction = new SystemNewFileFilterAction((IRemoteFileSubSystemConfiguration)factory, selectedPool, shell);
        } else {
            this._newFileFilterAction.setParentFilterPool(selectedPool);
        }
        return this._newFileFilterAction;
    }

    protected IAction getChangeFilterAction(ISubSystemConfiguration factory, ISystemFilter selectedFilter, Shell shell) {
        if (this._changeFilerAction == null) {
            this._changeFilerAction = new SystemFileUpdateFilterAction(shell);
        }
        return this._changeFilerAction;
    }

    protected Vector getAdditionalFilterActions(ISubSystemConfiguration factory, ISystemFilter selectedFilter, Shell shell) {
        if (this._additionalActions == null) {
            this._additionalActions = super.getAdditionalFilterActions(factory, selectedFilter, shell);
            if (selectedFilter.isPromptable()) {
                return this._additionalActions;
            }
            if (this._additionalActions == null) {
                this._additionalActions = new Vector();
            }
            this._additionalActions.add(new SystemNewFileAction(shell));
            this._additionalActions.add(new SystemNewFolderAction(shell));
            SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            Clipboard clipboard = registry.getSystemClipboard();
            this._additionalActions.add(new SystemPasteFromClipboardAction(shell, clipboard));
        }
        return this._additionalActions;
    }

    public void renameSubSystemProfile(ISubSystemConfiguration factory, String oldProfileName, String newProfileName) {
        IFolder folder;
        super.renameSubSystemProfile(factory, oldProfileName, newProfileName);
        IProject project = SystemBasePlugin.getWorkspaceRoot().getProject("RemoteSystemsTempFiles");
        if (project != null && (folder = project.getFolder(oldProfileName)) != null && folder.exists()) {
            this.recursivelyUpdateIFileProperties(newProfileName, folder);
        }
    }

    protected void recursivelyUpdateIFileProperties(String newName, IFolder container) {
        try {
            IResource[] resources = container.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
                    String absoluteSubSystemName = properties.getRemoteFileSubSystem();
                    if (absoluteSubSystemName != null) {
                        int profileDelim = absoluteSubSystemName.indexOf(".");
                        String theRest = absoluteSubSystemName.substring(profileDelim, absoluteSubSystemName.length());
                        properties.setRemoteFileSubSystem(String.valueOf(newName) + theRest);
                    }
                } else if (resource instanceof IFolder) {
                    this.recursivelyUpdateIFileProperties(newName, (IFolder)resource);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }
}

