/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.internal.subsystems;

import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;

public abstract class ServerLauncher
extends RSEModelObject
implements IServerLauncherProperties {
    protected String _name;
    protected IConnectorService _connectorService;

    protected ServerLauncher(String name, IConnectorService service) {
        this._name = name;
        this._connectorService = service;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return SystemResources.RESID_MODELOBJECTS_SERVERLAUNCHER_DESCRIPTION;
    }

    public IConnectorService getConnectorService() {
        return this._connectorService;
    }

    public IServerLauncherProperties cloneServerLauncher(IServerLauncherProperties newOne) {
        newOne.addPropertySets(this.getPropertySets());
        return newOne;
    }

    public void setVendorAttribute(String vendorName, String attributeName, String attributeValue) {
        IPropertySet set = this.getPropertySet(vendorName);
        if (set == null) {
            set = this.createPropertySet(vendorName, "");
        }
        set.addProperty(attributeName, attributeValue);
    }

    public String getVendorAttribute(String vendor, String attributeName) {
        IPropertySet set = this.getPropertySet(vendor);
        if (set != null) {
            return set.getPropertyValue(attributeName);
        }
        return null;
    }

    public boolean commit() {
        return RSEUIPlugin.getThePersistenceManager().commit(this.getConnectorService().getHost());
    }
}

