/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.rse.ui.ISystemContextMenuConstants;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.actions.SystemBaseSubMenuAction;
import org.eclipse.rse.ui.actions.SystemCascadingBrowseWithAction;
import org.eclipse.rse.ui.actions.SystemCascadingCompareWithAction;
import org.eclipse.rse.ui.actions.SystemCascadingExpandToAction;
import org.eclipse.rse.ui.actions.SystemCascadingNewAction;
import org.eclipse.rse.ui.actions.SystemCascadingOpenWithAction;
import org.eclipse.rse.ui.actions.SystemCascadingRemoteServersAction;
import org.eclipse.rse.ui.actions.SystemCascadingReplaceWithAction;
import org.eclipse.rse.ui.actions.SystemCascadingViewAction;
import org.eclipse.rse.ui.actions.SystemCascadingWorkWithAction;
import org.eclipse.rse.ui.actions.SystemSeparatorAction;

public class SystemMenuManager
implements ISystemContextMenuConstants {
    private IMenuManager mgr;
    private IMenuManager newSubMenu;
    private IMenuManager expandtoSubMenu;
    private IMenuManager openwithSubMenu;
    private IMenuManager browsewithSubMenu;
    private IMenuManager comparewithSubMenu;
    private IMenuManager replacewithSubMenu;
    private IMenuManager workwithSubMenu;
    private IMenuManager viewSubMenu;
    private IMenuManager serverSubMenu;
    private boolean menuCreated = false;

    public SystemMenuManager(IMenuManager menuManager) {
        this.mgr = menuManager;
    }

    public IMenuManager getMenuManager() {
        return this.mgr;
    }

    public void appendToGroup(String groupName, IAction action) {
        if (!this.checkForSpecialGroup(groupName, action, true)) {
            if (groupName != null) {
                this.mgr.appendToGroup(groupName, action);
            } else {
                this.mgr.add(action);
            }
        }
    }

    public void appendToGroup(String groupName, IContributionItem menuOrSeparator) {
        if (!this.checkForSpecialGroup(groupName, menuOrSeparator, true)) {
            if (groupName != null) {
                this.mgr.appendToGroup(groupName, menuOrSeparator);
            } else {
                this.mgr.add(menuOrSeparator);
            }
        }
    }

    public void prependToGroup(String groupName, IAction action) {
        if (!this.checkForSpecialGroup(groupName, action, false)) {
            this.mgr.prependToGroup(groupName, action);
        }
    }

    public void prependToGroup(String groupName, IContributionItem subMenu) {
        if (!this.checkForSpecialGroup(groupName, subMenu, true)) {
            this.mgr.prependToGroup(groupName, subMenu);
        }
    }

    public void addSeparator() {
        this.mgr.add((IContributionItem)new Separator());
    }

    public void add(String menuGroup, IAction action) {
        if (action instanceof SystemBaseSubMenuAction) {
            this.appendToGroup(this.getMenuGroup(action, menuGroup), (IContributionItem)((SystemBaseSubMenuAction)action).getSubMenu());
        } else if (!(action instanceof SystemSeparatorAction)) {
            this.appendToGroup(this.getMenuGroup(action, menuGroup), action);
        } else {
            this.appendToGroup(menuGroup, (IContributionItem)new Separator());
        }
    }

    private String getMenuGroup(IAction action, String defaultGroup) {
        if (action instanceof ISystemAction && ((ISystemAction)action).getContextMenuGroup() != null) {
            return ((ISystemAction)action).getContextMenuGroup();
        }
        return defaultGroup;
    }

    private boolean checkForSpecialGroup(String groupName, IAction action, boolean add) {
        boolean takenCareOf = false;
        IMenuManager subMenu = this.getSpecialSubMenu(groupName);
        if (subMenu != null) {
            takenCareOf = true;
            if (action instanceof SystemSeparatorAction) {
                subMenu.add((IContributionItem)new Separator());
                if (((SystemSeparatorAction)action).isRealAction()) {
                    subMenu.add(action);
                }
            } else {
                subMenu.add(action);
            }
        }
        return takenCareOf;
    }

    private boolean checkForSpecialGroup(String groupName, IContributionItem contribution, boolean add) {
        boolean takenCareOf = false;
        IMenuManager subMenu = this.getSpecialSubMenu(groupName);
        if (subMenu != null) {
            takenCareOf = true;
            subMenu.add(contribution);
        }
        return takenCareOf;
    }

    private IMenuManager getSpecialSubMenu(String groupName) {
        IMenuManager subMenu = null;
        this.menuCreated = false;
        if (groupName != null) {
            if (groupName.equals("group.new")) {
                if (this.newSubMenu == null) {
                    this.newSubMenu = new SystemCascadingNewAction().getSubMenu();
                    this.mgr.appendToGroup("group.new", (IContributionItem)this.newSubMenu);
                    this.menuCreated = true;
                }
                subMenu = this.newSubMenu;
            } else if (groupName.equals("group.expandto")) {
                if (this.expandtoSubMenu == null) {
                    this.expandtoSubMenu = new SystemCascadingExpandToAction().getSubMenu();
                    this.mgr.appendToGroup("group.expandto", (IContributionItem)this.expandtoSubMenu);
                    this.menuCreated = true;
                }
                subMenu = this.expandtoSubMenu;
            } else if (groupName.equals("group.openwith")) {
                if (this.openwithSubMenu == null) {
                    this.openwithSubMenu = new SystemCascadingOpenWithAction().getSubMenu();
                    this.mgr.appendToGroup("group.openwith", (IContributionItem)this.openwithSubMenu);
                    this.menuCreated = true;
                }
                subMenu = this.openwithSubMenu;
            } else if (groupName.equals("group.browsewith")) {
                if (this.browsewithSubMenu == null) {
                    this.browsewithSubMenu = new SystemCascadingBrowseWithAction().getSubMenu();
                    this.mgr.appendToGroup("group.browsewith", (IContributionItem)this.browsewithSubMenu);
                    this.menuCreated = true;
                }
                subMenu = this.browsewithSubMenu;
            } else if (groupName.equals("group.comparewith")) {
                if (this.comparewithSubMenu == null) {
                    this.comparewithSubMenu = new SystemCascadingCompareWithAction().getSubMenu();
                    this.mgr.appendToGroup("group.comparewith", (IContributionItem)this.comparewithSubMenu);
                    this.menuCreated = true;
                }
                subMenu = this.comparewithSubMenu;
            } else if (groupName.equals("group.replacewith")) {
                if (this.replacewithSubMenu == null) {
                    this.replacewithSubMenu = new SystemCascadingReplaceWithAction().getSubMenu();
                    this.mgr.appendToGroup("group.replacewith", (IContributionItem)this.replacewithSubMenu);
                    this.menuCreated = true;
                }
                subMenu = this.replacewithSubMenu;
            } else if (groupName.equals("group.workwith")) {
                if (this.workwithSubMenu == null) {
                    this.workwithSubMenu = new SystemCascadingWorkWithAction().getSubMenu();
                    this.mgr.appendToGroup("group.workwith", (IContributionItem)this.workwithSubMenu);
                    this.menuCreated = true;
                }
                subMenu = this.workwithSubMenu;
            } else if (groupName.equals("group.viewerSetup")) {
                if (this.viewSubMenu == null) {
                    this.viewSubMenu = new SystemCascadingViewAction().getSubMenu();
                    this.mgr.appendToGroup("group.viewerSetup", (IContributionItem)this.viewSubMenu);
                    this.menuCreated = true;
                }
                subMenu = this.viewSubMenu;
            } else if (groupName.equals("group.remoteservers")) {
                if (this.serverSubMenu == null) {
                    this.serverSubMenu = new SystemCascadingRemoteServersAction().getSubMenu();
                    this.mgr.appendToGroup("group.remoteservers", (IContributionItem)this.serverSubMenu);
                    this.menuCreated = true;
                }
                subMenu = this.serverSubMenu;
            }
        }
        return subMenu;
    }

    public IMenuManager getSpecialSubMenuByMenuID(String menuID) {
        IMenuManager subMenu = null;
        String groupName = null;
        this.menuCreated = false;
        if (menuID != null) {
            if (menuID.equals("menu.new")) {
                groupName = "group.new";
            } else if (menuID.equals("menu.goto")) {
                groupName = "group.goto";
            } else if (menuID.equals("menu.expandto")) {
                groupName = "group.expandto";
            } else if (menuID.equals("menu.openwith")) {
                groupName = "group.openwith";
            } else if (menuID.equals("menu.browsewith")) {
                groupName = "group.browsewith";
            } else if (menuID.equals("menu.comparewith")) {
                groupName = "group.comparewith";
            } else if (menuID.equals("menu.replacewith")) {
                groupName = "group.replacewith";
            } else if (menuID.equals("menu.workwith")) {
                groupName = "group.workwith";
            } else if (menuID.equals("menu.remoteservers")) {
                groupName = "group.remoteservers";
            }
            if (groupName != null) {
                subMenu = this.getSpecialSubMenu(groupName);
            }
        }
        return subMenu;
    }

    public boolean wasMenuCreated() {
        return this.menuCreated;
    }
}

