/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.ui.view.SystemPropertySheetForm;
import org.eclipse.rse.ui.view.SystemViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SystemControlEnableState {
    private List exceptions = null;
    private List states = new ArrayList();

    protected SystemControlEnableState(Control w) {
        this(w, null);
    }

    protected SystemControlEnableState(Control w, List exceptions) {
        this.exceptions = exceptions;
        this.readStateForAndDisable(w);
    }

    public static SystemControlEnableState disable(Control w) {
        return new SystemControlEnableState(w);
    }

    public static SystemControlEnableState disable(Control w, List exceptions) {
        return new SystemControlEnableState(w, exceptions);
    }

    private void readStateForAndDisable(Control w) {
        if (this.exceptions != null && this.exceptions.contains(w)) {
            return;
        }
        if (w instanceof Composite && !(w instanceof SystemViewForm) && !(w instanceof SystemPropertySheetForm)) {
            Composite c = (Composite)w;
            Control[] children = c.getChildren();
            int i = 0;
            while (i < children.length) {
                this.readStateForAndDisable(children[i]);
                ++i;
            }
        }
        this.states.add(new ItemState(w, w.getEnabled()));
        w.setEnabled(false);
    }

    public void restore() {
        int size = this.states.size();
        int i = 0;
        while (i < size) {
            ((ItemState)this.states.get(i)).restore();
            ++i;
        }
    }

    private class ItemState {
        protected Control item;
        protected boolean state;

        public ItemState(Control item, boolean state) {
            this.item = item;
            this.state = state;
        }

        public void restore() {
            if (this.item != null) {
                this.item.setEnabled(this.state);
            }
        }
    }
}

