/********************************************************************************
 * Copyright (c) 2004, 2006 IBM Corporation. All rights reserved.
 * This program and the accompanying materials are made available under the terms
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Initial Contributors:
 * The following IBM employees contributed to the Remote System Explorer
 * component that contains this file: David McKnight, Kushal Munir, 
 * Michael Berger, David Dykstal, Phil Coulthard, Don Yantzi, Eric Simpson, 
 * Emily Bruner, Mazen Faraj, Adrian Storisteanu, Li Ding, and Kent Hawley.
 * 
 * Contributors:
 * {Name} (company) - description of contribution.
 ********************************************************************************/

package org.eclipse.rse.ui.widgets.services;
import java.util.ArrayList;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ServiceTableContentProvider implements ITreeContentProvider 
{
	/**
	 * @see IStructuredContentProvider#getElements(Object)
	 */
	public Object[] getElements(Object element) {
		if (element instanceof ArrayList)
			return ((ArrayList)element).toArray();

		return getChildren(element);
	}
	/**
	 * @see IContentProvider#dispose()
	 */
	public void dispose() {
	}
	/**
	 * @see IContentProvider#inputChanged(Viewer, Object, Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) 
	{
	}
	
	public Object[] getChildren(Object element)
	{
		return getServiceElement(element).getChildren();
	}
	
	public Object getParent(Object element)
	{
		return getServiceElement(element).getParent();
	}
	
	public boolean hasChildren(Object element)
	{
		return getServiceElement(element).hasChildren();
	}
	
	protected ServiceElement getServiceElement(Object element)
	{
		return (ServiceElement)element;
	}
}