/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemHostPool;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.internal.model.Host;
import org.eclipse.rse.internal.model.SystemProfileManager;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;

public class SystemHostPool
extends RSEModelObject
implements ISystemHostPool {
    protected static final String NAME_EDEFAULT = null;
    private static Hashtable pools = null;
    private static String CONNECTION_FILE_NAME = "connection";
    protected String name = NAME_EDEFAULT;
    private List connections = null;

    protected SystemHostPool() {
    }

    public static void reset() {
        pools = null;
    }

    public static ISystemHostPool getSystemHostPool(ISystemProfile profile) throws Exception {
        SystemHostPool pool;
        if (pools == null) {
            pools = new Hashtable();
        }
        if ((pool = (SystemHostPool)((Object)pools.get(profile))) == null) {
            pool = new SystemHostPool();
            pool.setName(profile.getName());
            try {
                pool.restore();
            }
            catch (Exception exception) {}
            pools.put(profile, pool);
        }
        return pool;
    }

    public ISystemProfile getSystemProfile() {
        return SystemProfileManager.getSystemProfileManager().getSystemProfile(this.getName());
    }

    public void renameHostPool(String newName) {
        IHost[] connections = this.getHosts();
        String oldName = this.getName();
        int idx = 0;
        while (idx < connections.length) {
            connections[idx].renamingSystemProfile(oldName, newName);
            ++idx;
        }
        this.setName(newName);
    }

    public void printConnections() {
        List conns = this.getHostList();
        Iterator connsList = conns.iterator();
        if (!connsList.hasNext()) {
            System.out.println();
            System.out.println("No connections");
        }
        while (connsList.hasNext()) {
            System.out.println();
            IHost conn = (IHost)connsList.next();
            System.out.println("  AliasName.....: " + conn.getAliasName());
            System.out.println("  -----------------------------------------------------");
            System.out.println("  HostName......: " + conn.getHostName());
            System.out.println("  SystemType....: " + conn.getSystemType());
            System.out.println("  Description...: " + conn.getDescription());
            System.out.println("  UserId........: " + conn.getDefaultUserId());
        }
    }

    public IHost createHost(String systemType, String aliasName, String hostName) throws Exception {
        return this.createHost(systemType, aliasName, hostName, null, null, 2);
    }

    public IHost createHost(String systemType, String aliasName, String hostName, String description) throws Exception {
        return this.createHost(systemType, aliasName, hostName, description, null, 2);
    }

    public IHost createHost(String systemType, String aliasName, String hostName, String description, String defaultUserId, int defaultUserIdLocation) throws Exception {
        boolean exists;
        Host conn = null;
        boolean bl = exists = this.getHost(aliasName) != null;
        if (exists) {
            return null;
        }
        ISystemProfile profile = this.getSystemProfile();
        conn = new Host(profile);
        this.addHost(conn);
        conn.setHostPool(this);
        conn.setAliasName(aliasName);
        if (defaultUserId == null && defaultUserIdLocation == 2) {
            defaultUserId = conn.getDefaultUserId();
        }
        this.updateHost(conn, systemType, aliasName, hostName, description, defaultUserId, defaultUserIdLocation);
        return conn;
    }

    public void updateHost(IHost conn, String systemType, String aliasName, String hostName, String description, String defaultUserId, int defaultUserIdLocation) throws Exception {
        boolean aliasNameChanged;
        boolean bl = aliasNameChanged = !aliasName.equalsIgnoreCase(conn.getAliasName());
        if (aliasNameChanged) {
            this.renameHost(conn, aliasName);
        }
        conn.setSystemType(systemType);
        conn.setHostName(hostName);
        if (defaultUserIdLocation != 0) {
            if (defaultUserIdLocation != 2) {
                conn.setDefaultUserId(null);
                SystemPreferencesManager prefMgr = SystemPreferencesManager.getPreferencesManager();
                boolean forceToUpperCase = conn.getForceUserIdToUpperCase();
                if (forceToUpperCase && defaultUserId != null) {
                    defaultUserId = defaultUserId.toUpperCase();
                }
                if (defaultUserIdLocation == 3) {
                    prefMgr.setDefaultUserId(systemType, defaultUserId);
                }
            } else {
                conn.setDefaultUserId(defaultUserId);
            }
        }
        conn.setDescription(description);
        this.commit(conn);
    }

    public IHost[] getHosts() {
        return this.getHostList().toArray(new IHost[this.connections.size()]);
    }

    protected void invalidateCache() {
        this.setDirty(true);
    }

    public IHost getHost(String aliasName) {
        IHost conn = null;
        IHost currconn = null;
        List conns = this.getHostList();
        Iterator i = conns.iterator();
        while (i.hasNext() && conn == null) {
            currconn = (IHost)i.next();
            if (!currconn.getAliasName().equalsIgnoreCase(aliasName)) continue;
            conn = currconn;
        }
        return conn;
    }

    public IHost getHost(int pos) {
        List conns = this.getHostList();
        if (pos < conns.size()) {
            return (IHost)conns.get(pos);
        }
        return null;
    }

    public int getHostPosition(IHost conn) {
        int position = -1;
        boolean match = false;
        List conns = this.getHostList();
        Iterator i = conns.iterator();
        int idx = 0;
        while (!match && i.hasNext()) {
            IHost currConn = (IHost)i.next();
            if (conn.equals(currConn)) {
                match = true;
                position = idx;
            }
            ++idx;
        }
        return position;
    }

    public int getHostCount() {
        List conns = this.getHostList();
        return conns.size();
    }

    public boolean addHost(IHost conn) {
        List hostList = this.getHostList();
        if (!hostList.contains(conn)) {
            hostList.add(conn);
        }
        conn.setHostPool((ISystemHostPool)this);
        this.invalidateCache();
        return true;
    }

    public void deleteHost(IHost conn) {
        conn.deletingHost();
        this.getHostList().remove(conn);
        this.setDirty(true);
        RSEUIPlugin.getThePersistenceManager().commit(conn.getSystemProfile());
    }

    public void renameHost(IHost conn, String newName) throws Exception {
        conn.setAliasName(newName);
        this.invalidateCache();
        this.commit(conn);
    }

    public IHost cloneHost(ISystemHostPool targetPool, IHost conn, String aliasName) throws Exception {
        IHost copy = targetPool.createHost(conn.getSystemType(), aliasName, conn.getHostName(), conn.getDescription(), conn.getLocalDefaultUserId(), 2);
        return copy;
    }

    public void moveHosts(IHost[] conns, int delta) {
        int[] oldPositions = new int[conns.length];
        int idx = 0;
        while (idx < conns.length) {
            oldPositions[idx] = this.getHostPosition(conns[idx]);
            ++idx;
        }
        if (delta > 0) {
            idx = conns.length - 1;
            while (idx >= 0) {
                this.moveConnection(conns[idx], oldPositions[idx] + delta);
                --idx;
            }
        } else {
            idx = 0;
            while (idx < conns.length) {
                this.moveConnection(conns[idx], oldPositions[idx] + delta);
                ++idx;
            }
        }
        this.commit();
    }

    private void moveConnection(IHost conn, int newPos) {
        this.invalidateCache();
    }

    public void orderHosts(String[] names) {
        List connList = this.getHostList();
        IHost[] conns = new IHost[names.length];
        int idx = 0;
        while (idx < conns.length) {
            conns[idx] = this.getHost(names[idx]);
            ++idx;
        }
        connList.clear();
        idx = 0;
        while (idx < conns.length) {
            connList.add(conns[idx]);
            ++idx;
        }
        this.invalidateCache();
    }

    public boolean commit() {
        return RSEUIPlugin.getThePersistenceManager().commit((ISystemHostPool)this);
    }

    public void commit(IHost connection) {
        this.commit();
    }

    protected void restore() throws Exception {
    }

    protected IHost restore(String connectionName) throws Exception {
        return null;
    }

    protected static String getSaveFileName(IHost connection) {
        return null;
    }

    protected static String getRootSaveFileName(IHost connection) {
        return SystemHostPool.getRootSaveFileName(connection.getAliasName());
    }

    protected static String getRootSaveFileName(String connectionName) {
        String fileName = CONNECTION_FILE_NAME;
        return fileName;
    }

    public String toString() {
        if (this.getName() == null) {
            return this.toStringGen();
        }
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return SystemResources.RESID_MODELOBJECTS_HOSTPOOL_DESCRIPTION;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public List getHostList() {
        if (this.connections == null) {
            this.connections = new ArrayList();
        }
        return this.connections;
    }

    public String toStringGen() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

