/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemDeferredTableTreeContentManager;
import org.eclipse.rse.ui.view.SystemTableTreeView;
import org.eclipse.rse.ui.view.SystemTableViewColumnManager;
import org.eclipse.rse.ui.view.SystemViewPromptableAdapter;
import org.eclipse.rse.ui.view.SystemViewRootInputAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemTableTreeViewProvider
implements ILabelProvider,
ITableLabelProvider,
ITreeContentProvider {
    private ListenerList listeners = new ListenerList(1);
    protected Object[] _lastResults = null;
    protected Object _lastObject = null;
    protected SimpleDateFormat _dateFormat = new SimpleDateFormat();
    protected Viewer _viewer = null;
    protected int _maxCharsInColumnZero = 0;
    private SystemDeferredTableTreeContentManager manager;
    private boolean _disableDeferredQueries = false;
    private Map imageTable = new Hashtable(40);
    private SystemTableViewColumnManager _columnManager;
    private HashMap cache;
    static /* synthetic */ Class class$0;

    public SystemTableTreeViewProvider(SystemTableViewColumnManager columnManager) {
        this._columnManager = columnManager;
        this.cache = new HashMap();
    }

    public void inputChanged(Viewer visualPart, Object oldInput, Object newInput) {
        this._viewer = visualPart;
        if (this._viewer instanceof AbstractTreeViewer) {
            this.manager = new SystemDeferredTableTreeContentManager(this, (SystemTableTreeView)this._viewer);
        }
    }

    public void setCache(Object[] newCache) {
        this._lastResults = newCache;
    }

    public Object[] getCache() {
        return this._lastResults;
    }

    public boolean flushCache() {
        if (this._lastResults == null) {
            return false;
        }
        if (this._lastObject instanceof ISystemContainer) {
            ((ISystemContainer)this._lastObject).markStale(true);
        }
        this._lastResults = null;
        return true;
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    public Object[] getChildren(Object object) {
        return this.getElements(object);
    }

    public Object getParent(Object object) {
        ISystemViewElementAdapter adapter = this.getAdapterFor(object);
        if (adapter != null) {
            return adapter.getParent(object);
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        ISystemViewElementAdapter adapter = this.getAdapterFor(object);
        if (adapter != null) {
            return adapter.hasChildren(object);
        }
        if (this.manager != null && this.manager.isDeferredAdapter(object)) {
            return this.manager.mayHaveChildren(object);
        }
        return false;
    }

    public Object getElementAt(Object object, int i) {
        return null;
    }

    protected ISystemViewElementAdapter getAdapterFor(Object object) {
        ISystemViewElementAdapter result = null;
        result = this._viewer != null ? SystemAdapterHelpers.getAdapter(object, this._viewer) : SystemAdapterHelpers.getAdapter(object);
        if (result == null) {
            return null;
        }
        result.setPropertySourceInput(object);
        return result;
    }

    public Object[] getElements(Object object) {
        Object[] results = null;
        if (object == this._lastObject && this._lastResults != null) {
            return this._lastResults;
        }
        if (object instanceof IAdaptable) {
            ISystemViewElementAdapter adapter = this.getAdapterFor(object);
            adapter.setViewer(this._viewer);
            if (adapter != null && adapter.hasChildren(object)) {
                if (this.supportsDeferredQueries()) {
                    ISubSystem ss;
                    if (this.manager != null && adapter.supportsDeferredQueries() && (ss = adapter.getSubSystem(object)) != null) {
                        results = this.manager.getChildren(object);
                    }
                } else {
                    results = adapter.getChildren(object);
                }
                if (adapter instanceof SystemViewRootInputAdapter) {
                    ArrayList<Object> filterredResults = new ArrayList<Object>();
                    int i = 0;
                    while (i < results.length) {
                        Object result = results[i];
                        ISystemViewElementAdapter cadapter = this.getAdapterFor(result);
                        if (!(cadapter instanceof SystemViewPromptableAdapter)) {
                            filterredResults.add(result);
                        }
                        ++i;
                    }
                    results = filterredResults.toArray();
                }
                this._lastResults = results;
                this._lastObject = object;
            }
        }
        if (results == null) {
            return new Object[0];
        }
        return results;
    }

    public String getText(Object object) {
        String result = null;
        ISystemViewElementAdapter adapter = this.getAdapterFor(object);
        if (adapter == null) {
            IWorkbenchAdapter wadapter;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wadapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) == null) {
                return object.toString();
            }
            return wadapter.getLabel(object);
        }
        result = adapter.getText(object);
        int len = result.length();
        if (len > this._maxCharsInColumnZero) {
            this._maxCharsInColumnZero = len;
        }
        return result;
    }

    public int getMaxCharsInColumnZero() {
        return this._maxCharsInColumnZero;
    }

    public Image getImage(Object object) {
        ImageDescriptor descriptor = null;
        ISystemViewElementAdapter adapter = this.getAdapterFor(object);
        if (adapter != null) {
            descriptor = adapter.getImageDescriptor(object);
        } else {
            IWorkbenchAdapter wadapter;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wadapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) == null) {
                return null;
            }
            descriptor = wadapter.getImageDescriptor(object);
        }
        Image image = null;
        if (descriptor != null) {
            Object iobj = this.imageTable.get(descriptor);
            if (iobj == null) {
                image = descriptor.createImage();
                this.imageTable.put(descriptor, image);
            } else {
                image = (Image)iobj;
            }
        }
        return image;
    }

    public String getColumnText(Object obj, int index) {
        if (index == 0) {
            return this.getText(obj);
        }
        --index;
        ISystemViewElementAdapter adapter = this.getAdapterFor(obj);
        if (adapter == null) {
            return null;
        }
        IPropertyDescriptor[] descriptors = null;
        descriptors = this._columnManager != null ? this._columnManager.getVisibleDescriptors(adapter) : adapter.getUniquePropertyDescriptors();
        if (descriptors.length > index) {
            IPropertyDescriptor descriptor = descriptors[index];
            try {
                Object key = descriptor.getId();
                Object propertyValue = adapter.getPropertyValue(key);
                if (propertyValue instanceof String) {
                    return (String)propertyValue;
                }
                if (propertyValue instanceof Date) {
                    return this._dateFormat.format((Date)propertyValue);
                }
                if (propertyValue != null) {
                    return propertyValue.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public Image getColumnImage(Object obj, int i) {
        if (i == 0) {
            return this.getImage(obj);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setCachedObjects(Object parent, Object[] children) {
        this.cache.put(parent, children);
        this._lastObject = parent;
        this._lastResults = children;
    }

    public Object[] getCachedObjects(Object parent) {
        return (Object[])this.cache.get(parent);
    }

    public void dispose() {
    }

    public void disableDeferredQueries(boolean disable) {
        this._disableDeferredQueries = disable;
    }

    protected boolean supportsDeferredQueries() {
        if (this._disableDeferredQueries) {
            return false;
        }
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.rse.preferences.useDeferredQueries");
    }
}

