/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view.monitor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemTableTreeView;
import org.eclipse.rse.ui.view.monitor.MonitorViewPage;
import org.eclipse.rse.ui.view.monitor.SystemMonitorViewPart;
import org.eclipse.rse.ui.view.monitor.TabFolderLayout;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MonitorViewWorkbook
extends Composite {
    private CTabFolder _folder = new CTabFolder((Composite)this, 0);
    private SystemMonitorViewPart _viewPart;
    static /* synthetic */ Class class$0;

    public MonitorViewWorkbook(Composite parent, SystemMonitorViewPart viewPart) {
        super(parent, 0);
        this._folder.setLayout((Layout)new TabFolderLayout());
        this._folder.setLayoutData((Object)new GridData(1808));
        this.setLayout((Layout)new FillLayout());
        this._viewPart = viewPart;
    }

    public void dispose() {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed()) {
                MonitorViewPage page = (MonitorViewPage)item.getData();
                page.dispose();
            }
            ++i;
        }
        this._folder.dispose();
        super.dispose();
    }

    public CTabFolder getFolder() {
        return this._folder;
    }

    public void remove(Object root) {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            MonitorViewPage page;
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed() && (page = (MonitorViewPage)item.getData()) != null && root == page.getInput()) {
                item.dispose();
                page.dispose();
                page = null;
                item = null;
                this._folder.redraw();
                return;
            }
            ++i;
        }
    }

    public void removeDisconnected() {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            MonitorViewPage page;
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed() && (page = (MonitorViewPage)item.getData()) != null) {
                ISubSystem subSystem;
                ISystemViewElementAdapter adapter;
                IAdaptable input = (IAdaptable)page.getInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (ISystemViewElementAdapter)input.getAdapter((Class)clazz)) != null && (subSystem = adapter.getSubSystem(input)) != null && !subSystem.isConnected()) {
                    item.dispose();
                    page.dispose();
                    page = null;
                    item = null;
                    this._folder.redraw();
                }
            }
            ++i;
        }
    }

    public CTabItem getSelectedTab() {
        if (this._folder.getItemCount() > 0) {
            int index = this._folder.getSelectionIndex();
            CTabItem item = this._folder.getItem(index);
            return item;
        }
        return null;
    }

    public MonitorViewPage getCurrentTabItem() {
        if (this._folder.getItemCount() > 0) {
            int index = this._folder.getSelectionIndex();
            CTabItem item = this._folder.getItem(index);
            return (MonitorViewPage)item.getData();
        }
        return null;
    }

    public void showCurrentPage() {
        this._folder.setFocus();
    }

    public Object getInput() {
        MonitorViewPage page = this.getCurrentTabItem();
        if (page != null) {
            page.setFocus();
            return page.getInput();
        }
        return null;
    }

    public SystemTableTreeView getViewer() {
        if (this.getCurrentTabItem() != null) {
            return this.getCurrentTabItem().getViewer();
        }
        return null;
    }

    public void addItemToMonitor(IAdaptable root, boolean createTab) {
        if (!this._folder.isDisposed()) {
            int i = 0;
            while (i < this._folder.getItemCount()) {
                CTabItem item = this._folder.getItem(i);
                MonitorViewPage page = (MonitorViewPage)item.getData();
                if (page != null && root == page.getInput()) {
                    page.getViewer().refresh();
                    if (this._folder.getSelectionIndex() != i) {
                        this._folder.setSelection(item);
                    }
                    this.updateActionStates();
                    return;
                }
                ++i;
            }
            if (createTab) {
                this.createTabItem(root);
            }
        }
    }

    private void createTabItem(IAdaptable root) {
        MonitorViewPage monitorViewPage = new MonitorViewPage(this._viewPart);
        CTabItem titem = new CTabItem(this._folder, 0);
        this.setTabTitle(root, titem);
        titem.setData((Object)monitorViewPage);
        titem.setControl((Control)monitorViewPage.createTabFolderPage(this._folder, this._viewPart.getEditorActionHandler()));
        this._folder.setSelection(titem);
        monitorViewPage.setInput(root);
        SystemTableTreeView viewer = monitorViewPage.getViewer();
        this._viewPart.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this._viewPart.getSite().registerContextMenu(viewer.getContextMenuManager(), (ISelectionProvider)viewer);
        monitorViewPage.setFocus();
    }

    private void setTabTitle(IAdaptable root, CTabItem titem) {
        ISystemViewElementAdapter va;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((va = (ISystemViewElementAdapter)root.getAdapter((Class)clazz)) != null) {
            titem.setText(va.getName(root));
            titem.setImage(va.getImageDescriptor(root).createImage());
        }
    }

    public void setInput(IAdaptable root) {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            CTabItem item = this._folder.getItem(i);
            MonitorViewPage page = (MonitorViewPage)item.getData();
            if (root == page.getInput()) {
                this._folder.setSelection(i);
                page.getViewer().refresh();
                return;
            }
            ++i;
        }
    }

    public void updateActionStates() {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            MonitorViewPage page;
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed() && (page = (MonitorViewPage)item.getData()) != null) {
                page.updateActionStates();
            }
            ++i;
        }
    }
}

