/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets.services;

import java.util.ArrayList;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertyType;
import org.eclipse.rse.core.model.PropertySet;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.widgets.services.PropertyElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertySetServiceElement
extends ServiceElement
implements IPropertySource {
    protected PropertyElement[] _properties;
    protected IPropertySet _propertySet;
    protected IPropertySet _originalPropertySet;

    public PropertySetServiceElement(IHost host, ServiceElement parent, IPropertySet propertySet) {
        super(host, parent);
        this._propertySet = propertySet;
        this._originalPropertySet = new PropertySet(this._propertySet);
    }

    public IPropertySet getOriginalProperySet() {
        return this._originalPropertySet;
    }

    public IPropertySet getPropertySet() {
        return this._propertySet;
    }

    public Image getImage() {
        return RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.properties_objIcon");
    }

    public String getName() {
        return this._propertySet.getName();
    }

    public String getDescription() {
        return this._propertySet.getDescription();
    }

    public boolean hasChildren() {
        return false;
    }

    public ServiceElement[] getChildren() {
        return null;
    }

    public void refreshProperties() {
        this._properties = null;
    }

    public boolean hasProperties() {
        return this._propertySet.getPropertyKeys().length > 0;
    }

    public PropertyElement[] getProperties() {
        if (this._properties == null) {
            String[] keys = this._propertySet.getPropertyKeys();
            ArrayList<PropertyElement> enabledProperties = new ArrayList<PropertyElement>();
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                IProperty property = this._propertySet.getProperty(key);
                if (property.isEnabled()) {
                    enabledProperties.add(new PropertyElement(this, property));
                }
                ++i;
            }
            this._properties = enabledProperties.toArray(new PropertyElement[enabledProperties.size()]);
        }
        return this._properties;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        PropertyElement[] properties = this.getProperties();
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[properties.length];
        int i = 0;
        while (i < properties.length) {
            descriptors[i] = properties[i].getPropertyDescriptor();
            ++i;
        }
        return descriptors;
    }

    private PropertyElement getPropertyElement(String id) {
        PropertyElement[] elements = this.getProperties();
        int i = 0;
        while (i < elements.length) {
            PropertyElement element = elements[i];
            if (element.getKey().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        return this.getPropertyElement((String)id).getValue();
    }

    public boolean isPropertySet(Object id) {
        return this.getPropertyElement((String)id) != null;
    }

    public void resetPropertyValue(Object id) {
        PropertyElement element = this.getPropertyElement((String)id);
        if (element.getKey().equals(id)) {
            element.setValue(this._propertySet.getPropertyValue((String)id));
        }
    }

    public void setPropertyValue(Object id, Object value) {
        PropertyElement element = this.getPropertyElement((String)id);
        String strValue = null;
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            IPropertyType type = element.getType();
            if (type.isEnum()) {
                strValue = type.getEnumValues()[intValue];
            } else if (type.isInteger()) {
                strValue = intValue.toString();
            }
        } else {
            strValue = (String)value;
        }
        if (element.getKey().equals(id)) {
            element.setValue(strValue);
        }
        this.refreshProperties();
        this.childChanged(this);
    }

    public Object getEditableValue() {
        return this;
    }

    public void commit() {
        PropertyElement[] properties = this.getProperties();
        int i = 0;
        while (i < properties.length) {
            properties[i].commit();
            ++i;
        }
    }

    public void revert() {
        PropertyElement[] properties = this.getProperties();
        int i = 0;
        while (i < properties.length) {
            properties[i].revert();
            ++i;
        }
    }
}

