/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;

public abstract class AbstractFileService
implements IFileService {
    public static final int FILE_TYPE_FILES_AND_FOLDERS = 0;
    public static final int FILE_TYPE_FILES = 1;
    public static final int FILE_TYPE_FOLDERS = 2;

    public IHostFile[] getFiles(IProgressMonitor monitor, String remoteParent, String fileFilter) throws SystemMessageException {
        return this.internalFetch(monitor, remoteParent, fileFilter, 1);
    }

    public IHostFile[] getFolders(IProgressMonitor monitor, String remoteParent, String fileFilter) throws SystemMessageException {
        return this.internalFetch(monitor, remoteParent, fileFilter, 2);
    }

    public IHostFile[] getFilesAndFolders(IProgressMonitor monitor, String parentPath, String fileFilter) throws SystemMessageException {
        return this.internalFetch(monitor, parentPath, fileFilter, 0);
    }

    protected abstract IHostFile[] internalFetch(IProgressMonitor var1, String var2, String var3, int var4) throws SystemMessageException;

    protected boolean isRightType(int fileType, IHostFile node) {
        switch (fileType) {
            case 0: {
                return true;
            }
            case 1: {
                return node.isFile();
            }
            case 2: {
                return node.isDirectory();
            }
        }
        return true;
    }

    public SystemMessage getMessage(String messageID) {
        return null;
    }

    public boolean deleteBatch(IProgressMonitor monitor, String[] remoteParents, String[] fileNames) throws SystemMessageException {
        boolean ok = true;
        int i = 0;
        while (i < remoteParents.length) {
            ok = ok && this.delete(monitor, remoteParents[i], fileNames[i]);
            ++i;
        }
        return ok;
    }
}

