/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.dstore.old;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.internal.extra.DomainEvent;
import org.eclipse.dstore.extra.internal.extra.IDomainListener;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteSearchResult;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteSearchResultsContentsType;
import org.eclipse.rse.subsystems.files.dstore.model.DStoreFile;
import org.eclipse.rse.subsystems.files.dstore.model.DStoreSearchResult;
import org.eclipse.rse.subsystems.files.dstore.old.UniversalSearchResultConfigurationImpl;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SearchResultsChangeListener
implements IDomainListener,
ICommunicationsListener {
    private Shell _shell;
    private UniversalSearchResultConfigurationImpl _searchConfig;
    private DataElement _status;
    private IRemoteFileSubSystem _subsys;
    private DataStore _dataStore;
    private IRemoteFileContext _defaultContext;
    private IRemoteFileContext _currentContext;
    private long _lastUpdateTime;
    private boolean _disconnected = false;
    private boolean _cancelled = false;
    private static int MAX_RESULTS = 10000;

    public SearchResultsChangeListener(Shell shell, UniversalSearchResultConfigurationImpl searchConfig) {
        this._shell = shell;
        this._searchConfig = searchConfig;
        IRemoteFile rmtFile = (IRemoteFile)this._searchConfig.getSearchTarget();
        this._subsys = rmtFile.getParentRemoteFileSubSystem();
        this._status = this._searchConfig.getStatusObject();
        this._dataStore = this._status.getDataStore();
        this._dataStore.getDomainNotifier().addDomainListener((IDomainListener)this);
        this._subsys.getConnectorService().addCommunicationsListener((ICommunicationsListener)this);
        this._lastUpdateTime = 0L;
        RSEUIPlugin.getTheSystemRegistry();
        if (this._status.getValue().equals("done")) {
            this.setDone();
        } else if (this._status.getValue().equals("cancelled")) {
            this._cancelled = true;
            this.setDone();
        }
    }

    public IHostSearchResultConfiguration getSearchResults() {
        return this._searchConfig;
    }

    public DataElement getStatus() {
        return this._status;
    }

    public boolean listeningTo(DomainEvent event) {
        DataElement parent = (DataElement)event.getParent();
        if (this._status == null) {
            return false;
        }
        if (this._status == parent) {
            return true;
        }
        return this._status.getParent() == parent;
    }

    public void domainChanged(DomainEvent event) {
        if (!this._subsys.isConnected()) {
            this._disconnected = true;
            this.setDone();
            return;
        }
        if (this._status.getValue().equals("done")) {
            this.setDone();
        } else if (this._status.getValue().equals("cancelled")) {
            this._cancelled = true;
            this.setDone();
        } else {
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - this._lastUpdateTime;
            if (deltaTime > (long)this._searchConfig.getResultsSize() && this._searchConfig.getResultsSize() < MAX_RESULTS) {
                this._lastUpdateTime = currentTime;
                this.handleSearchResults();
            }
        }
    }

    private void handleSearchResults() {
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        List results = this._status.getNestedData();
        if (results != null) {
            int currentSize;
            int totalSize = results.size();
            int loop = currentSize = this._searchConfig.getResultsSize();
            while (loop < totalSize && loop < MAX_RESULTS) {
                DataElement result = (DataElement)results.get(loop);
                if (this._defaultContext == null) {
                    this._currentContext = this._defaultContext = new RemoteFileContext(this._subsys, null, null);
                }
                if (result.getName().length() > 0) {
                    char slash = '/';
                    if (this._subsys.getHost().getSystemType().equals("Windows")) {
                        slash = '\\';
                    }
                    String parentPath = result.getValue();
                    boolean isParentArchive = ArchiveHandlerManager.getInstance().isRegisteredArchive(parentPath);
                    int lastSlash = parentPath.lastIndexOf(slash);
                    if (lastSlash > 0) {
                        String parentName = parentPath.substring(lastSlash + 1, parentPath.length());
                        String parentRoot = parentPath.substring(0, lastSlash);
                        if (this._currentContext.getParentRemoteFile() == null || !this._currentContext.getParentRemoteFile().getAbsolutePath().equals(parentPath)) {
                            DataElement parentElement = null;
                            parentElement = ArchiveHandlerManager.isVirtual((String)parentRoot) ? result.getDataStore().createObject(null, "universal.VirtualFolderObject", parentName) : (!isParentArchive ? result.getDataStore().createObject(null, "universal.FolderObject", parentName) : result.getDataStore().createObject(null, "universal.ArchiveFileObject", parentName));
                            parentElement.setAttribute(3, parentRoot);
                            try {
                                IRemoteFile remoteFileParent = this._subsys.getRemoteFileObject(parentPath);
                                this._currentContext = new RemoteFileContext(this._subsys, remoteFileParent, null);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        this._currentContext = this._defaultContext;
                    }
                    if (!this._subsys.isConnected()) {
                        this._disconnected = true;
                        this.setDone();
                        return;
                    }
                    IRemoteFile remoteFile = null;
                    String remotePath = String.valueOf(parentPath) + slash + result.getName();
                    if (this._subsys instanceof FileServiceSubSystem) {
                        remoteFile = ((FileServiceSubSystem)this._subsys).getCachedRemoteFile(remotePath);
                    }
                    if (remoteFile == null) {
                        try {
                            remoteFile = this._subsys.getRemoteFileObject(remotePath);
                            ((RemoteFileSubSystem)this._subsys).cacheRemoteFile(remoteFile, remotePath);
                            ((RemoteFile)remoteFile).setParentRemoteFile(this._currentContext.getParentRemoteFile());
                        }
                        catch (Exception exception) {}
                    }
                    if (remoteFile != null) {
                        if (result.getNestedSize() > 0) {
                            boolean isWindows = this._subsys.getHost().getSystemType().equals("Windows");
                            char separator = isWindows ? (char)'\\' : '/';
                            ArrayList<DStoreSearchResult> contents = new ArrayList<DStoreSearchResult>();
                            int i = 0;
                            while (i < result.getNestedSize()) {
                                DataElement resultElement = result.get(i);
                                DStoreSearchResult searchResult = new DStoreSearchResult((IHostSearchResultConfiguration)this._searchConfig, remoteFile, resultElement, this._searchConfig.getSearchString());
                                searchResult.setText(resultElement.getName());
                                String source = resultElement.getSource().replace('\\', separator).replace('/', separator);
                                String lineNumStr = null;
                                int colonIndex = source.indexOf(":");
                                if (colonIndex > 2) {
                                    source.substring(0, colonIndex);
                                    lineNumStr = source.substring(colonIndex);
                                }
                                int lineNum = 0;
                                if (lineNumStr != null && lineNumStr.length() > 0) {
                                    Integer lineLocation = new Integer(lineNumStr);
                                    lineNum = lineLocation;
                                }
                                searchResult.setLine(lineNum);
                                searchResult.setIndex(i);
                                contents.add(searchResult);
                                ++i;
                            }
                            ((DStoreFile)remoteFile).setContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), this._searchConfig.getSearchString().toString(), contents.toArray());
                        }
                        this._searchConfig.addResult(remoteFile);
                    }
                }
                ++loop;
            }
            if (totalSize >= MAX_RESULTS) {
                RemoteSearchResult warning = new RemoteSearchResult((IHostSearchResultConfiguration)this._searchConfig, (Object)this._searchConfig, this._searchConfig.getSearchString());
                warning.setLine(0);
                warning.setText(RSEUIPlugin.getPluginMessage((String)"RSEG1101").getLevelOneText());
                this._searchConfig.addResult(warning);
            }
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._searchConfig, 82, null));
        }
    }

    public void setDone() {
        this._status.getDataStore().getDomainNotifier().removeDomainListener((IDomainListener)this);
        this._subsys.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
        if (!this._disconnected) {
            this.handleSearchResults();
            if (this._cancelled) {
                this._searchConfig.setStatus(2);
            } else {
                this._searchConfig.setStatus(1);
            }
        } else {
            this._searchConfig.setStatusObject(null);
            this._searchConfig.setStatus(3);
        }
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._searchConfig, 150, null));
    }

    public Shell getShell() {
        return this._shell;
    }

    public boolean wasCancelled() {
        return this._cancelled;
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        int connState = e.getState();
        if (connState == 5 || connState == 4) {
            this._disconnected = true;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SearchResultsChangeListener.this.setDone();
                }
            });
        }
    }

    public boolean isPassiveCommunicationsListener() {
        return true;
    }
}

