/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files.ftp;

import java.io.File;
import org.apache.commons.net.ftp.FTPFile;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.files.IHostFile;

public class FTPHostFile
implements IHostFile {
    private String _name;
    private String _parentPath;
    private boolean _isDirectory;
    private boolean _isArchive;
    private long _lastModified;
    private long _size;
    private boolean _canRead = true;
    private boolean _canWrite = true;
    private boolean _isRoot;
    private boolean _exists;

    public FTPHostFile(String parentPath, String name, boolean isDirectory, boolean isRoot, long lastModified, long size, boolean exists) {
        this._parentPath = parentPath;
        this._name = name;
        this._isDirectory = isDirectory;
        this._lastModified = lastModified;
        this._size = size;
        this._isArchive = this.internalIsArchive();
        this._canRead = true;
        this._canWrite = false;
        this._isRoot = isRoot;
        this._exists = exists;
    }

    public FTPHostFile(String parentPath, FTPFile ftpFile, String systemName) {
        this._parentPath = parentPath;
        this._name = ftpFile.getName();
        this._isDirectory = ftpFile.isDirectory();
        this._lastModified = ftpFile.getTimestamp().getTimeInMillis();
        this._size = ftpFile.getSize();
        this._isArchive = this.internalIsArchive();
        if (!systemName.toUpperCase().startsWith("WINDOWS")) {
            this._canRead = ftpFile.hasPermission(0, 0);
            this._canWrite = ftpFile.hasPermission(0, 1);
        }
        this._isRoot = false;
        this._exists = true;
    }

    public long getSize() {
        return this._size;
    }

    public boolean isDirectory() {
        return this._isDirectory;
    }

    public boolean isFile() {
        return !this._isDirectory && !this._isRoot;
    }

    public String getName() {
        return this._name;
    }

    public boolean canRead() {
        return this._canRead;
    }

    public boolean canWrite() {
        return this._canWrite;
    }

    public boolean exists() {
        return this._exists;
    }

    public String getAbsolutePath() {
        if (this.isRoot()) {
            return this.getName();
        }
        StringBuffer path = new StringBuffer(this.getParentPath());
        if (!this._parentPath.endsWith("/")) {
            path.append('/');
        }
        path.append(this.getName());
        return path.toString();
    }

    public long getModifiedDate() {
        return this._lastModified;
    }

    public String geParentPath() {
        return this._parentPath;
    }

    public boolean isArchive() {
        return this._isArchive;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isRoot() {
        return this._parentPath == null;
    }

    public String getParentPath() {
        return this._parentPath;
    }

    public void renameTo(String newAbsolutePath) {
        int i = newAbsolutePath.lastIndexOf("/");
        if (i == -1) {
            this._name = newAbsolutePath;
        } else {
            this._parentPath = newAbsolutePath.substring(0, i);
            this._name = newAbsolutePath.substring(i + 1);
        }
        this._isArchive = this.internalIsArchive();
    }

    protected boolean internalIsArchive() {
        return ArchiveHandlerManager.getInstance().isArchive(new File(this.getAbsolutePath())) && !ArchiveHandlerManager.isVirtual((String)this.getAbsolutePath());
    }
}

