/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.ftp.connectorservice;

import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.AbstractConnectorService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.ftp.FTPService;
import org.eclipse.rse.subsystems.files.core.SystemFileResources;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;

public class FTPConnectorService
extends AbstractConnectorService {
    protected FTPService _ftpService = new FTPService();

    public FTPConnectorService(IHost host, int port) {
        super(SystemFileResources.RESID_FTP_CONNECTORSERVICE_NAME, SystemFileResources.RESID_FTP_CONNECTORSERVICE_DESCRIPTION, host, port);
    }

    public void internalConnect(IProgressMonitor monitor) throws Exception {
        this.internalConnect();
    }

    private void internalConnect() throws Exception {
        SystemSignonInformation info = this.getPasswordInformation();
        this._ftpService.setHostName(info.getHostname());
        this._ftpService.setUserId(info.getUserid());
        this._ftpService.setPassword(info.getPassword());
        this._ftpService.setPortNumber(this.getPort());
        this._ftpService.setLoggingStream(this.getLoggingStream(info.getHostname(), this.getPort()));
        this._ftpService.connect();
    }

    private OutputStream getLoggingStream(String hostName, int portNumber) {
        MessageConsole messageConsole = null;
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int i = 0;
        while (i < consoles.length) {
            if (consoles[i].getName().equals("FTP log: " + hostName + ":" + portNumber)) {
                messageConsole = (MessageConsole)consoles[i];
                break;
            }
            ++i;
        }
        if (messageConsole == null) {
            messageConsole = new MessageConsole("FTP log: " + hostName + ":" + portNumber, null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        }
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView(messageConsole);
        return messageConsole.newOutputStream();
    }

    public IFileService getFileService() {
        return this._ftpService;
    }

    public void internalDisconnect(IProgressMonitor monitor) {
        this._ftpService.disconnect();
    }

    public boolean hasRemoteServerLauncherProperties() {
        return false;
    }

    public boolean supportsRemoteServerLaunching() {
        return false;
    }

    public boolean isConnected() {
        return this._ftpService != null && this._ftpService.isConnected();
    }

    public boolean supportsServerLaunchProperties() {
        return false;
    }
}

