/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.shells.subsystems;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteCmdSubSystem;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteOutput;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.ICandidateCommand;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.RSEUIPlugin;

public abstract class RemoteCommandShell
implements IAdaptable,
IRemoteCommandShell {
    protected String _id;
    protected String _name;
    protected String _type;
    protected IRemoteFile _cwd;
    protected ArrayList _output = new ArrayList();
    protected IRemoteFileSubSystem _fileSubSystem;
    protected IRemoteCmdSubSystem _cmdSubSystem;
    protected ArrayList _cmdHistory = new ArrayList();
    protected IProject _project;

    public RemoteCommandShell(IRemoteCmdSubSystem cmdSubSystem) {
        this._cmdSubSystem = cmdSubSystem;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getId() {
        if (this._id == null) {
            IRemoteCmdSubSystem subSystem = this.getCommandSubSystem();
            IHost connection = subSystem.getHost();
            String name = connection.getAliasName();
            IRemoteCommandShell[] shells = subSystem.getShells();
            ArrayList<String> currentNames = new ArrayList<String>();
            int i = 0;
            while (i < shells.length) {
                IRemoteCommandShell shell = shells[i];
                if (shell != this && shell instanceof RemoteCommandShell) {
                    currentNames.add(((RemoteCommandShell)shell)._id);
                }
                ++i;
            }
            if (currentNames.size() > 0) {
                int number = 2;
                String newName = String.valueOf(name) + " " + number;
                if (currentNames.contains(name)) {
                    while (currentNames.contains(newName)) {
                        newName = String.valueOf(name) + " " + ++number;
                    }
                    name = newName;
                }
            }
            this._id = name;
        }
        return this._id;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public Object[] listOutput() {
        return this._output.toArray();
    }

    public int getIndexOf(Object output) {
        return this._output.indexOf(output);
    }

    public Object getOutputAt(int index) {
        return this._output.get(index);
    }

    public int getSize() {
        return this._output.size();
    }

    public void addOutput(Object output) {
        this._output.add(output);
    }

    public void removeOutput() {
        this._output.clear();
    }

    public void removeOutput(Object output) {
        this._output.remove(output);
    }

    public IRemoteFileSubSystem getFileSubSystem() {
        if (this._fileSubSystem == null && this._cmdSubSystem != null) {
            this._fileSubSystem = RemoteFileUtility.getFileSubSystem((IHost)this._cmdSubSystem.getHost());
        }
        return this._fileSubSystem;
    }

    public IRemoteCmdSubSystem getCommandSubSystem() {
        if (this._cmdSubSystem == null && this._fileSubSystem != null) {
            try {
                IHost host = this._fileSubSystem.getHost();
                SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
                ISubSystem[] sses = sr.getSubSystems(host);
                int i = 0;
                while (i < sses.length) {
                    if (sses[i] instanceof IRemoteCmdSubSystem) {
                        RemoteCmdSubSystem cmdSubSystem = (RemoteCmdSubSystem)sses[i];
                        this._cmdSubSystem = cmdSubSystem;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        return this._cmdSubSystem;
    }

    public Object[] getRoots() {
        Object[] results = new RemoteOutput[this._output.size()];
        int i = 0;
        while (i < this._output.size()) {
            results[i] = (RemoteOutput)this._output.get(i);
            ++i;
        }
        return results;
    }

    public abstract String getTitle();

    public abstract boolean isActive();

    public void updateHistory(String cmd) {
        this._cmdHistory.add(cmd);
    }

    public String[] getHistory() {
        String[] cmds = null;
        if (this._cmdHistory.size() > 0) {
            cmds = new String[this._cmdHistory.size()];
            int i = 0;
            while (i < cmds.length) {
                cmds[i] = (String)this._cmdHistory.get(i);
                ++i;
            }
        } else {
            cmds = new String[]{};
        }
        return cmds;
    }

    public Object getContext() {
        return this._cwd;
    }

    public IRemoteFile getWorkingDirectory() {
        return this._cwd;
    }

    public void setWorkingDirectory(IRemoteFile file) {
        this._cwd = file;
    }

    protected boolean isWindows() {
        String type = this.getCommandSubSystem().getHost().getSystemType();
        return type.equals("Windows") || type.equals("Local") && System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public abstract ICandidateCommand[] getCandidateCommands();

    public void associateProject(IProject project) {
        this._project = project;
    }

    public IProject getAssociatedProject() {
        return this._project;
    }
}

