/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.model;

import org.eclipse.rse.core.model.IPropertyType;

public class PropertyType
implements IPropertyType {
    private int _type = 0;
    private String[] _enumValues;
    private static final String ENUMERATION_STR = "enumeration:";
    private static IPropertyType _booleanPropertyType = new PropertyType(3);
    private static IPropertyType _integerPropertyType = new PropertyType(1);
    private static IPropertyType _stringPropertyType = new PropertyType(0);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private PropertyType(int type) {
        this._type = type;
    }

    public static IPropertyType getBooleanPropertyType() {
        return _booleanPropertyType;
    }

    public static IPropertyType getIntegerPropertyType() {
        return _integerPropertyType;
    }

    public static IPropertyType getStringPropertyType() {
        return _stringPropertyType;
    }

    public static IPropertyType getEnumPropertyType(String[] values) {
        PropertyType type = new PropertyType(2);
        type.setEnumValues(values);
        return type;
    }

    public static IPropertyType fromString(String typeStr) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeStr.equals(clazz.toString())) {
            return PropertyType.getStringPropertyType();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeStr.equals(clazz2.toString())) {
            return PropertyType.getIntegerPropertyType();
        }
        if (typeStr.startsWith(ENUMERATION_STR)) {
            String subString = typeStr.substring(ENUMERATION_STR.length());
            String[] enumValues = subString.split(",");
            return PropertyType.getEnumPropertyType(enumValues);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeStr.equals(clazz3.toString())) {
            return PropertyType.getBooleanPropertyType();
        }
        return PropertyType.getStringPropertyType();
    }

    public int getType() {
        return this._type;
    }

    public boolean isString() {
        return this._type == 0;
    }

    public boolean isInteger() {
        return this._type == 1;
    }

    public boolean isEnum() {
        return this._type == 2;
    }

    public boolean isBoolean() {
        return this._type == 3;
    }

    private void setEnumValues(String[] enumValues) {
        this._enumValues = enumValues;
    }

    public String[] getEnumValues() {
        return this._enumValues;
    }

    public String toString() {
        if (this.isString()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getName();
        }
        if (this.isInteger()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getName();
        }
        if (this.isEnum()) {
            StringBuffer buf = new StringBuffer();
            buf.append(ENUMERATION_STR);
            String[] enumValues = this.getEnumValues();
            int i = 0;
            while (i < enumValues.length) {
                buf.append(enumValues[i]);
                if (i + 1 < enumValues.length) {
                    buf.append(",");
                }
                ++i;
            }
            return buf.toString();
        }
        if (this.isBoolean()) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getName();
        }
        return super.toString();
    }
}

