/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.text.MessageFormat;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.persistence.Messages;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;

public class SaveRSEDOMJob
extends WorkspaceJob {
    private RSEDOM _dom;
    private IRSEPersistenceProvider _provider;

    public SaveRSEDOMJob(RSEDOM dom, IRSEPersistenceProvider provider) {
        super("Saving Profile");
        String title = MessageFormat.format(Messages.SaveRSEDOMJob_SavingProfileJobName, dom.getName());
        this.setName(title);
        this._dom = dom;
        this._provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        RSEDOM rSEDOM = this._dom;
        synchronized (rSEDOM) {
            if (this._dom.needsSave()) {
                this._provider.saveRSEDOM(this._dom, monitor);
                this._dom.markUpdated();
            } else {
                result = Status.CANCEL_STATUS;
            }
        }
        return result;
    }
}

