/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui;

import java.util.ArrayList;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteCmdSubSystem;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteCommandShell;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.shells.ui.view.SystemCommandsUI;
import org.eclipse.rse.shells.ui.view.SystemCommandsViewPart;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RemoteCommandHelpers {
    public static String getWorkingDirectory(IRemoteFile selectedFile) {
        String path = null;
        path = selectedFile.isDirectory() ? selectedFile.getAbsolutePath() : selectedFile.getParentPath();
        return path;
    }

    public static IRemoteCmdSubSystem getCmdSubSystem(IHost connection) {
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISubSystem[] sses = sr.getSubSystems(connection);
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteCmdSubSystem) {
                RemoteCmdSubSystem cmdSubSystem = (RemoteCmdSubSystem)sses[i];
                return cmdSubSystem;
            }
            ++i;
        }
        return null;
    }

    public static IRemoteCmdSubSystem[] getCmdSubSystems(IHost connection) {
        ArrayList<RemoteCmdSubSystem> results = new ArrayList<RemoteCmdSubSystem>();
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISubSystem[] sses = sr.getSubSystems(connection);
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteCmdSubSystem) {
                RemoteCmdSubSystem cmdSubSystem = (RemoteCmdSubSystem)sses[i];
                results.add(cmdSubSystem);
            }
            ++i;
        }
        return results.toArray(new IRemoteCmdSubSystem[results.size()]);
    }

    public static boolean runUniversalCommand(Shell shell, String cmdString, String path, IRemoteCmdSubSystem cmdSubSystem) {
        return RemoteCommandHelpers.runUniversalCommand(shell, cmdString, path, cmdSubSystem, false);
    }

    public static boolean runUniversalCommand(Shell shell, String cmdString, String path, IRemoteCmdSubSystem cmdSubSystem, boolean isCompile) {
        boolean ok = false;
        if (cmdSubSystem != null) {
            ok = true;
            try {
                IRemoteCommandShell defaultShell = cmdSubSystem.getDefaultShell();
                RemoteCommandHelpers.showInView(defaultShell, isCompile, cmdString);
                IRemoteFileSubSystemConfiguration fileSSF = RemoteFileUtility.getFileSubSystemConfiguration((String)cmdSubSystem.getHost().getSystemType());
                IRemoteFile pwd = ((RemoteCommandShell)defaultShell).getWorkingDirectory();
                if (pwd == null || !pwd.getAbsolutePath().equals(path)) {
                    String cdCmd = "cd " + PathUtility.enQuoteUnix((String)path);
                    if (!fileSSF.isUnixStyle()) {
                        if (path.endsWith(":")) {
                            path = String.valueOf(path) + "\\";
                        }
                        cdCmd = "cd /d \"" + path + '\"';
                    }
                    cmdSubSystem.sendCommandToShell(cdCmd, (Object)defaultShell);
                }
                cmdSubSystem.sendCommandToShell(cmdString, (Object)defaultShell);
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Run Remote Command failed", (Throwable)e);
                SystemMessageDialog.displayExceptionMessage((Shell)shell, (Exception)e);
                ok = false;
            }
        }
        return ok;
    }

    public static void showInView(IRemoteCommandShell cmd, boolean isCompile, String cmdString) {
        SystemCommandsViewPart cmdsPart = SystemCommandsUI.getInstance().activateCommandsView();
        cmdsPart.updateOutput(cmd);
    }
}

