/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.view;

import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.shells.ui.view.SystemBuildErrorViewPart;
import org.eclipse.rse.shells.ui.view.SystemCommandsViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SystemCommandsUI {
    private static SystemCommandsUI instance;
    private static SystemCommandsViewPart _viewPart;
    private static SystemBuildErrorViewPart _errorPart;
    public static final String COMMANDS_VIEW_ID = "org.eclipse.rse.shells.ui.view.commandsView";
    public static final String BUILD_ERROR_VIEW_ID = "org.eclipse.rse.shells.ui.view.buildErrorView";

    private SystemCommandsUI() {
    }

    public static SystemCommandsUI getInstance() {
        if (instance == null) {
            instance = new SystemCommandsUI();
        }
        return instance;
    }

    public SystemBuildErrorViewPart activateBuildErrorView() {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            _errorPart = (SystemBuildErrorViewPart)page.showView(BUILD_ERROR_VIEW_ID);
            page.bringToTop((IWorkbenchPart)_errorPart);
        }
        catch (PartInitException e) {
            SystemBasePlugin.logError((String)"Can not open build error view", (Throwable)e);
        }
        return _errorPart;
    }

    public SystemCommandsViewPart activateCommandsView() {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            _viewPart = (SystemCommandsViewPart)page.showView(COMMANDS_VIEW_ID);
            page.bringToTop((IWorkbenchPart)_viewPart);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            SystemBasePlugin.logError((String)"Can not open remote shell view", (Throwable)e);
        }
        return _viewPart;
    }

    public static SystemBuildErrorViewPart getBuildErrorView() {
        return _errorPart;
    }

    public static SystemCommandsViewPart getCommandsView() {
        return _viewPart;
    }
}

