/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemDownloadConflictAction
extends SystemBaseAction
implements Runnable {
    protected IFile _tempFile;
    protected boolean _remoteNewer;
    protected int _state;
    public static final int REPLACE_WITH_REMOTE = 0;
    public static final int OPEN_WITH_LOCAL = 1;
    public static final int CANCELLED = 2;

    public SystemDownloadConflictAction(IFile tempFile, boolean remoteNewer) {
        super(FileResources.RESID_CONFLICT_DOWNLOAD_TITLE, null);
        this._tempFile = tempFile;
        this._remoteNewer = remoteNewer;
    }

    public SystemDownloadConflictAction(String title, IFile tempFile, boolean remoteNewer) {
        super(title, null);
        this._tempFile = tempFile;
        this._remoteNewer = remoteNewer;
    }

    public int getState() {
        return this._state;
    }

    protected DownloadConflictDialog getConflictDialog() {
        DownloadConflictDialog dlg = new DownloadConflictDialog(SystemBasePlugin.getActiveWorkbenchShell(), this._remoteNewer);
        if (this._remoteNewer) {
            dlg.setDialogText(FileResources.RESID_CONFLICT_DOWNLOAD_MESSAGE_REMOTECHANGED);
        } else {
            dlg.setDialogText(FileResources.RESID_CONFLICT_DOWNLOAD_MESSAGE_LOCALCHANGED);
        }
        dlg.setReplaceText(FileResources.RESID_CONFLICT_DOWNLOAD_REPLACELOCAL);
        dlg.setOpenLocalText(FileResources.RESID_CONFLICT_DOWNLOAD_OPENWITHLOCAL);
        dlg.setHelpId("org.eclipse.rse.ui.lcdl0000");
        return dlg;
    }

    public void run() {
        this.setShell(RSEUIPlugin.getTheSystemRegistry().getShell());
        SystemIFileProperties properties = new SystemIFileProperties((IResource)this._tempFile);
        DownloadConflictDialog cnfDialog = this.getConflictDialog();
        if (cnfDialog.open() == 0) {
            this._state = cnfDialog.keepLocal() ? 1 : 0;
        } else {
            this._state = 2;
            properties.setDirty(true);
        }
    }

    protected class DownloadConflictDialog
    extends SystemPromptDialog {
        private Button _keepLocalButton;
        private Button _replaceLocalButton;
        private boolean _keepLocal;
        private String _openLocalText;
        private String _replaceText;
        private String _dialogText;
        private String _helpId;

        public DownloadConflictDialog(Shell shell, boolean remoteNewer) {
            super(shell, FileResources.RESID_CONFLICT_DOWNLOAD_TITLE);
        }

        public boolean keepLocal() {
            return this._keepLocal;
        }

        protected void buttonPressed(int buttonId) {
            this.setReturnCode(buttonId);
            this._keepLocal = this._keepLocalButton.getSelection();
            this.close();
        }

        public Control createInner(Composite parent) {
            Image image = this.getShell().getDisplay().getSystemImage(4);
            Composite c = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            c.setLayout((Layout)layout);
            c.setLayoutData((Object)new GridData(1808));
            Composite m = new Composite(c, 0);
            GridLayout mlayout = new GridLayout();
            mlayout.numColumns = 2;
            m.setLayout((Layout)mlayout);
            m.setLayoutData((Object)new GridData(1808));
            Label label = new Label(m, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
            Text text = new Text(m, 66);
            text.setEditable(false);
            text.setText(this._dialogText);
            Composite options = new Composite(c, 0);
            GridLayout olayout = new GridLayout();
            olayout.numColumns = 1;
            options.setLayout((Layout)olayout);
            options.setLayoutData((Object)new GridData(1808));
            this._replaceLocalButton = new Button(options, 16);
            this._replaceLocalButton.setText(this._replaceText);
            this._replaceLocalButton.setSelection(true);
            this._keepLocalButton = new Button(options, 16);
            this._keepLocalButton.setText(this._openLocalText);
            this.setHelp();
            return c;
        }

        protected Control getInitialFocusControl() {
            this.enableOkButton(true);
            return this._replaceLocalButton;
        }

        private void setHelp() {
            this.setHelp(this._helpId);
        }

        public void setHelpId(String id) {
            this._helpId = id;
        }

        public void setDialogText(String dialogText) {
            this._dialogText = dialogText;
        }

        public void setReplaceText(String replaceText) {
            this._replaceText = replaceText;
        }

        public void setOpenLocalText(String openLocalText) {
            this._openLocalText = openLocalText;
        }
    }
}

