/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class SystemRemoteMarkerTypeDefinition {
    protected String type = null;
    protected String name = null;
    protected boolean isPersistent = false;
    protected Set superTypes = null;
    protected Set attributeNames = null;

    public SystemRemoteMarkerTypeDefinition(IExtension ext) {
        this.type = ext.getUniqueIdentifier();
        this.name = ext.getLabel();
        this.process(ext);
    }

    private void process(IExtension ext) {
        HashSet<String> types = null;
        HashSet<String> attributes = null;
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String bool;
            String name;
            String type;
            IConfigurationElement element = elements[i];
            if (element.getName().equalsIgnoreCase("super") && (type = element.getAttribute("type")) != null) {
                if (types == null) {
                    types = new HashSet<String>(3);
                }
                types.add(type);
            }
            if (element.getName().equalsIgnoreCase("attribute") && (name = element.getAttribute("name")) != null) {
                if (attributes == null) {
                    attributes = new HashSet<String>(3);
                }
                attributes.add(name);
            }
            if (element.getName().equalsIgnoreCase("persistent") && (bool = element.getAttribute("value")) != null) {
                this.isPersistent = new Boolean(bool);
            }
            ++i;
        }
        this.superTypes = types;
        this.attributeNames = attributes;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public Set getSuperTypes() {
        return this.superTypes;
    }

    public Set getAttributeNames() {
        return this.attributeNames;
    }
}

