/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.widgets;

import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.widgets.SystemSelectRemoteFileOrFolderForm;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ValidatorFileName;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemEnterOrSelectRemoteFileForm
extends SystemSelectRemoteFileOrFolderForm {
    protected Text fileNameText;
    protected String fileName;
    protected String initialFileName;
    protected ValidatorFileName validator = new ValidatorFileName();

    public SystemEnterOrSelectRemoteFileForm(ISystemMessageLine msgLine, Object caller, boolean fileMode) {
        super(msgLine, caller, fileMode);
        this.fileName = this.initialFileName = "";
    }

    public Control createContents(Shell shell, Composite parent) {
        Control control = super.createContents(shell, parent);
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)2);
        this.fileNameText = SystemWidgetHelpers.createLabeledTextField((Composite)composite, null, (String)FileResources.RESID_NEWFILE_NAME_LABEL, (String)FileResources.RESID_NEWFILE_NAME_TOOLTIP);
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemEnterOrSelectRemoteFileForm.this.fileName = SystemEnterOrSelectRemoteFileForm.this.fileNameText.getText();
                SystemEnterOrSelectRemoteFileForm.this.setPageComplete();
            }
        });
        if (this.fileName != null) {
            this.fileNameText.setText(this.fileName);
        }
        return control;
    }

    public boolean verify() {
        boolean ok = super.verify();
        if (ok) {
            IRemoteFile file = (IRemoteFile)this.getSelectedObject();
            IRemoteFile saveasFile = null;
            try {
                saveasFile = file.getParentRemoteFileSubSystem().getRemoteFileObject(file, this.fileName);
            }
            catch (Exception exception) {}
            if (saveasFile != null && saveasFile.exists()) {
                SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF5012");
                msg.makeSubstitution((Object)this.fileName);
                SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), msg);
                ok = dlg.openQuestionNoException();
            }
        }
        return ok;
    }

    public boolean isPageComplete() {
        SystemMessage errMsg = null;
        if (this.fileName != null) {
            errMsg = this.validator.validate(this.fileName);
        }
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        this.clearErrorMessage();
        return this.fileNameText != null && this.fileNameText.getText().length() > 0 && super.isPageComplete();
    }

    public void setPreSelection(IRemoteFile selection) {
        if (selection.isDirectory()) {
            super.setPreSelection(selection);
        } else if (selection.isFile()) {
            IRemoteFile parentFile = selection.getParentRemoteFile();
            if (parentFile.isDirectory()) {
                super.setPreSelection(parentFile);
            }
            this.fileName = this.initialFileName = parentFile.getName();
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        super.selectionChanged(e);
        Object selectedObject = this.getFirstSelection(e.getSelection());
        if (selectedObject != null && selectedObject instanceof IRemoteFile) {
            IRemoteFile remoteFile = (IRemoteFile)selectedObject;
            ISystemRemoteElementAdapter remoteAdapter = this.getRemoteAdapter(selectedObject);
            if (remoteAdapter != null && this.fileNameText != null) {
                Object parentFile = this.tree.getSelectedParent();
                if (remoteFile.isFile()) {
                    this.fileName = remoteAdapter.getName(selectedObject);
                    this.fileNameText.setText(this.fileName);
                } else {
                    this.fileName = this.initialFileName;
                    this.fileNameText.setText(this.fileName);
                    parentFile = remoteFile;
                }
                remoteAdapter = this.getRemoteAdapter(parentFile);
                if (remoteAdapter != null) {
                    String fullPath = remoteAdapter.getAbsoluteName(parentFile);
                    this.setNameText(fullPath);
                    this.outputObjects = new Object[]{parentFile};
                    this.setPageComplete();
                }
            }
        }
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter((Object)o);
    }

    public String getFileName() {
        return this.fileName;
    }
}

