/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.widgets;

import java.util.Hashtable;
import java.util.ResourceBundle;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.actions.SystemSelectRemoteFolderAction;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.widgets.ISystemCombo;
import org.eclipse.rse.ui.widgets.SystemHistoryCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SystemQualifiedRemoteFolderCombo
extends Composite
implements ISystemCombo {
    public static final char CONNECTION_DELIMITER = ':';
    private Label folderLabel = null;
    private SystemHistoryCombo folderCombo = null;
    private Button browseButton = null;
    private Hashtable resolvedFolders = new Hashtable();
    private String[] systemTypes;
    private boolean readOnly = true;
    private boolean showNewPrompt = true;
    private SystemSelectRemoteFolderAction browseAction = null;

    public SystemQualifiedRemoteFolderCombo(Composite parent, int style, String historyKey) {
        super(parent, style);
        this.prepareComposite(3);
        this.folderLabel = SystemWidgetHelpers.createLabel((Composite)this, (String)SystemFileResources.WIDGET_FOLDER_LABEL, (String)SystemFileResources.WIDGET_FOLDER_TOOLTIP);
        if (historyKey == null) {
            historyKey = "org.eclipse.rse.preferences.history.qualified.folder";
        }
        this.folderCombo = SystemWidgetHelpers.createHistoryCombo((Composite)this, null, (String)historyKey, (boolean)this.readOnly, (String)SystemFileResources.WIDGET_FOLDER_TOOLTIP);
        Object folderData = this.folderCombo.getLayoutData();
        if (folderData instanceof GridData) {
            ((GridData)folderData).widthHint = 200;
        }
        this.browseButton = SystemQualifiedRemoteFolderCombo.createPushButton(this, SystemFileResources.WIDGET_BROWSE_LABEL);
        this.addOurButtonSelectionListener();
    }

    public void setAutoUpperCase(boolean enable) {
        this.folderCombo.setAutoUpperCase(enable);
    }

    public void setSystemTypes(String[] systemTypes) {
        this.systemTypes = systemTypes;
    }

    public void setSystemType(String systemType) {
        if (systemType == null) {
            this.setSystemTypes(null);
        } else {
            this.setSystemTypes(new String[]{systemType});
        }
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.showNewPrompt = show;
        if (this.browseAction != null) {
            this.browseAction.setShowNewConnectionPrompt(show);
        }
    }

    public SystemHistoryCombo getFolderCombo() {
        return this.folderCombo;
    }

    public SystemHistoryCombo getHistoryCombo() {
        return this.folderCombo;
    }

    public Combo getCombo() {
        return this.folderCombo.getCombo();
    }

    public void setWidthHint(int widthHint) {
        ((GridData)this.getLayoutData()).widthHint = widthHint;
    }

    public Button getBrowseButton() {
        return this.browseButton;
    }

    public void setFolders(IRemoteFile[] folders) {
        if (folders == null) {
            this.folderCombo.setItems(null);
            return;
        }
        String[] folderStrings = new String[folders.length];
        int idx = 0;
        while (idx < folders.length) {
            folderStrings[idx] = folders[idx].getAbsolutePathPlusConnection();
            ++idx;
        }
        this.folderCombo.setItems(folderStrings);
        this.folderCombo.select(0);
        this.updateHistory();
    }

    public int addFolder(IRemoteFile folder) {
        int pos = -1;
        String[] folderStrings = this.folderCombo.getItems();
        if (folderStrings == null) {
            folderStrings = new String[]{folder.getAbsolutePathPlusConnection()};
            pos = 0;
        } else {
            String[] newFolderStrings = new String[folderStrings.length + 1];
            int idx = 0;
            while (idx < folderStrings.length) {
                newFolderStrings[idx] = folderStrings[idx];
                ++idx;
            }
            pos = newFolderStrings.length - 1;
            newFolderStrings[pos] = folder.getAbsolutePathPlusConnection();
            folderStrings = newFolderStrings;
        }
        this.folderCombo.setItems(folderStrings);
        this.folderCombo.setHistory(folderStrings);
        return pos;
    }

    public void removeFolder(IRemoteFile folder) {
        int idx = this.getFolderIndex(folder);
        if (idx > -1) {
            this.folderCombo.getCombo().remove(idx);
            this.updateHistory();
        }
    }

    public String[] getItems() {
        return this.folderCombo.getItems();
    }

    public int getFolderIndex(IRemoteFile folder) {
        int match = -1;
        String[] folderStrings = this.folderCombo.getItems();
        if (folderStrings == null || folderStrings.length == 0) {
            return match;
        }
        folder.getSystemConnection();
        String fulldir = folder.getAbsolutePathPlusConnection();
        int idx = 0;
        while (idx < folderStrings.length && match == -1) {
            if (folderStrings[idx].equals(fulldir)) {
                match = idx;
            }
            ++idx;
        }
        return match;
    }

    public void setFolder(IRemoteFile folder) {
        int idx = this.getFolderIndex(folder);
        if (idx == -1) {
            idx = this.addFolder(folder);
        }
        this.select(idx);
    }

    public void setSelectionIndex(int selIdx) {
        this.select(selIdx);
    }

    public void select(int selIdx) {
        this.folderCombo.clearSelection();
        this.folderCombo.select(selIdx);
    }

    public void clearSelection() {
        this.folderCombo.clearSelection();
    }

    public void clearTextSelection() {
        this.folderCombo.clearTextSelection();
    }

    public int getSelectionIndex() {
        return this.folderCombo.getSelectionIndex();
    }

    public String getText() {
        return this.folderCombo.getText();
    }

    public IRemoteFile getFolder() throws Exception {
        String fileString = this.folderCombo.getText().trim();
        if (fileString.length() == 0) {
            return null;
        }
        IRemoteFile fileObj = (IRemoteFile)this.resolvedFolders.get(fileString);
        if (fileObj == null && (fileObj = this.convertToRemoteFile(fileString)) != null) {
            this.resolvedFolders.put(fileString, fileObj);
        }
        return fileObj;
    }

    public IHost getSystemConnection() {
        String fileString = this.folderCombo.getText().trim();
        if (fileString.length() == 0) {
            return null;
        }
        String profileName = SystemQualifiedRemoteFolderCombo.extractProfileName(fileString);
        String connName = SystemQualifiedRemoteFolderCombo.extractConnectionName(fileString);
        if (profileName == null || connName == null) {
            return null;
        }
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISystemProfile profile = sr.getSystemProfile(profileName);
        if (profile == null) {
            return null;
        }
        IHost conn = RSEUIPlugin.getTheSystemRegistry().getHost(profile, connName);
        return conn;
    }

    public void setEnabled(boolean enabled) {
        this.folderCombo.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public void setToolTipText(String tip) {
        this.folderLabel.setToolTipText(tip);
        this.folderCombo.setToolTipText(tip);
    }

    public void setBrowseButtonToolTipText(String tip) {
        this.browseButton.setToolTipText(tip);
    }

    public void setButtonToolTipText(String tip) {
        this.setBrowseButtonToolTipText(tip);
    }

    public void setTextLimit(int limit) {
        this.folderCombo.setTextLimit(limit);
    }

    public boolean setFocus() {
        return this.folderCombo.setFocus();
    }

    public void setBrowseButtonFocus() {
        this.browseButton.setFocus();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.folderCombo.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.folderCombo.removeSelectionListener(listener);
    }

    public void addBrowseButtonSelectionListener(SelectionListener listener) {
        this.browseButton.addSelectionListener(listener);
    }

    public void removeBrowseButtonSelectionListener(SelectionListener listener) {
        this.browseButton.removeSelectionListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.folderCombo.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.folderCombo.removeModifyListener(listener);
    }

    public static String[] getHistory() {
        return SystemPreferencesManager.getPreferencesManager().getFolderHistory();
    }

    public void updateHistory() {
        this.folderCombo.updateHistory();
    }

    public IRemoteFile convertToRemoteFile(String qualifiedFolder) throws Exception {
        SystemMessage msg = null;
        String profileName = SystemQualifiedRemoteFolderCombo.extractProfileName(qualifiedFolder);
        String connName = SystemQualifiedRemoteFolderCombo.extractConnectionName(qualifiedFolder);
        String dirName = SystemQualifiedRemoteFolderCombo.extractFolder(qualifiedFolder);
        if (profileName == null || connName == null || dirName == null) {
            return null;
        }
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISystemProfile profile = sr.getSystemProfile(profileName);
        if (profile == null) {
            msg = RSEUIPlugin.getPluginMessage((String)"RSEG1104");
            msg.makeSubstitution((Object)profileName);
            throw new Exception(msg.getLevelOneText());
        }
        IHost conn = RSEUIPlugin.getTheSystemRegistry().getHost(profile, connName);
        if (conn == null) {
            msg = RSEUIPlugin.getPluginMessage((String)"RSEG1103");
            msg.makeSubstitution((Object)connName);
            throw new Exception(msg.getLevelOneText());
        }
        IRemoteFile remoteFolder = null;
        ISubSystem[] filesubsystems = null;
        filesubsystems = RemoteFileUtility.getFileSubSystems((IHost)conn);
        if (filesubsystems.length == 0) {
            msg = RSEUIPlugin.getPluginMessage((String)"RSEG1103");
            msg.makeSubstitution((Object)connName);
            throw new Exception(msg.getLevelOneText());
        }
        IRemoteFileSubSystem ss = (IRemoteFileSubSystem)filesubsystems[0];
        if (!ss.isConnected()) {
            try {
                ss.connect();
            }
            catch (InterruptedException interruptedException) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEG1058");
                msg.makeSubstitution((Object)conn.getHostName());
                throw new Exception(msg.getLevelOneText());
            }
            catch (Exception exception) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEG1056");
                msg.makeSubstitution((Object)conn.getHostName());
                throw new Exception(msg.getLevelOneText());
            }
        }
        if (ss.isConnected()) {
            remoteFolder = ss.getRemoteFileObject(dirName);
        }
        return remoteFolder;
    }

    public static String extractQualifiedConnectionName(String qualifiedFolder) {
        int idx = qualifiedFolder.indexOf(58);
        if (idx == -1) {
            return null;
        }
        return qualifiedFolder.substring(0, idx);
    }

    public static String extractProfileName(String qualifiedConnectionName) {
        int idx = qualifiedConnectionName.indexOf(46);
        if (idx == -1) {
            return null;
        }
        return qualifiedConnectionName.substring(0, idx);
    }

    public static String extractConnectionName(String qualifiedConnectionName) {
        int idx = qualifiedConnectionName.indexOf(46);
        if (idx == -1) {
            return null;
        }
        String nonProfile = qualifiedConnectionName.substring(idx + 1);
        if ((idx = nonProfile.indexOf(58)) == -1) {
            return nonProfile;
        }
        return nonProfile.substring(0, idx);
    }

    public static String extractFolder(String qualifiedFolder) {
        int idx = qualifiedFolder.indexOf(58);
        if (idx == -1) {
            return null;
        }
        return qualifiedFolder.substring(idx + 1);
    }

    protected Composite prepareComposite(int numColumns) {
        SystemQualifiedRemoteFolderCombo composite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData(data);
        return composite;
    }

    protected void addOurButtonSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IHost defaultConnection = null;
                IRemoteFile currFolder = null;
                try {
                    currFolder = SystemQualifiedRemoteFolderCombo.this.getFolder();
                }
                catch (Exception exception) {}
                if (currFolder != null) {
                    defaultConnection = currFolder.getSystemConnection();
                }
                if (SystemQualifiedRemoteFolderCombo.this.browseAction == null) {
                    SystemQualifiedRemoteFolderCombo.this.browseAction = SystemQualifiedRemoteFolderCombo.this.getBrowseAction(SystemQualifiedRemoteFolderCombo.this.getShell(), defaultConnection);
                }
                SystemQualifiedRemoteFolderCombo.this.browseAction.setShowNewConnectionPrompt(SystemQualifiedRemoteFolderCombo.this.showNewPrompt);
                SystemQualifiedRemoteFolderCombo.this.browseAction.setHost(defaultConnection);
                SystemQualifiedRemoteFolderCombo.this.browseAction.setSystemTypes(SystemQualifiedRemoteFolderCombo.this.systemTypes);
                SystemQualifiedRemoteFolderCombo.this.browseAction.run();
                IRemoteFile folder = SystemQualifiedRemoteFolderCombo.this.browseAction.getSelectedFolder();
                if (folder != null) {
                    SystemQualifiedRemoteFolderCombo.this.setFolder(folder);
                }
            }
        };
        this.browseButton.addSelectionListener((SelectionListener)selectionListener);
    }

    protected SystemSelectRemoteFolderAction getBrowseAction(Shell shell, IHost defaultConnection) {
        SystemSelectRemoteFolderAction action = new SystemSelectRemoteFolderAction(shell);
        return action;
    }

    public static Button createPushButton(Composite group, String label) {
        Button button = new Button(group, 8);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        button.setLayoutData((Object)data);
        return button;
    }

    protected static Button createPushButton(Composite group, ResourceBundle bundle, String key) {
        String label = bundle.getString(String.valueOf(key) + "label");
        Button button = SystemQualifiedRemoteFolderCombo.createPushButton(group, label);
        button.setToolTipText(bundle.getString(String.valueOf(key) + "tooltip"));
        return button;
    }
}

